.\" $XdotOrg: xc/programs/Xserver/hw/xfree86/Xorg.man,v 1.2 2004/04/23 19:20:02 eich Exp $
.TH __xservername__ __appmansuffix__ __vendorversion__
.SH NAME
__xservername__ - X11R6 X server
.SH SYNOPSIS
.B __xservername__
.RI [\fB:\fP display ]
.RI [ option
.IR ... ]
.SH DESCRIPTION
.B __xservername__
is a full featured X server that was originally designed for UNIX and
UNIX-like operating systems running on Intel x86 hardware.  It now runs
on a wider range of hardware and OS platforms.
.PP
This work was derived from
.I "XFree86\ 4.4rc2"
by the X.Org Foundation.
The XFree86 4.4rc2 release was originally derived from
.I "X386\ 1.2"
by Thomas Roell which was contributed to X11R5 by Snitily Graphics
Consulting Service.  The
.B __xservername__
server architecture includes
among many other things a loadable module system derived from code
donated by Metro Link, Inc.  The current __xservername__ release is compatible
with X11R6.6.
.SH PLATFORMS
.PP
.B __xservername__
operates under a wide range of operating systems and hardware platforms.
The Intel x86 (IA32) architecture is the most widely supported hardware
platform.  Other hardware platforms include Compaq Alpha, Intel IA64,
SPARC and PowerPC.  The most widely supported operating systems are the
free/OpenSource UNIX-like systems such as Linux, FreeBSD, NetBSD and
OpenBSD.  Commercial UNIX operating systems such as Solaris (x86) and
UnixWare are also supported.  Other supported operating systems include
LynxOS, and GNU Hurd.  Darwin and Mac OS X are supported with the
XDarwin(1) X server.  Win32/Cygwin is supported with the XWin X server.
.PP
.SH "NETWORK CONNECTIONS"
.B __xservername__
supports connections made using the following reliable
byte-streams:
.TP 4
.I "Local"
On most platforms, the "Local" connection type is a UNIX-domain socket.
On some System V platforms, the "local" connection types also include
STREAMS pipes, named pipes, and some other mechanisms.
.TP 4
.I TCP\/IP
.B __xservername__
listens on port
.RI 6000+ n ,
where
.I n
is the display number.  This connection type can be disabled with the
.B \-nolisten
option (see the Xserver(1) man page for details).
.SH "ENVIRONMENT VARIABLES"
For operating systems that support local connections other than Unix
Domain sockets (SVR3 and SVR4), there is a compiled-in list specifying
the order in which local connections should be attempted.  This list
can be overridden by the
.I XLOCAL
environment variable described below.  If the display name indicates a
best-choice connection should be made (e.g.
.BR :0.0 ),
each connection mechanism is tried until a connection succeeds or no
more mechanisms are available.  Note: for these OSs, the Unix Domain
socket connection is treated differently from the other local connection
types.  To use it the connection must be made to
.BR unix:0.0 .
.PP
The
.I XLOCAL
environment variable should contain a list of one more
more of the following:
.PP
.RS 8
.nf
NAMED
PTS
SCO
ISC
.fi
.RE
.PP
which represent SVR4 Named Streams pipe, Old-style USL Streams pipe,
SCO XSight Streams pipe, and ISC Streams pipe, respectively.  You can
select a single mechanism (e.g.
.IR XLOCAL=NAMED ),
or an ordered list (e.g. \fIXLOCAL="NAMED:PTS:SCO"\fP).
his variable overrides the compiled-in defaults.  For SVR4 it is
recommended that
.I NAMED
be the first preference connection.  The default setting is
.IR PTS:NAMED:ISC:SCO .
.PP
To globally override the compiled-in defaults, you should define (and
export if using
.B sh
or
.BR ksh )
.I XLOCAL
globally.  If you use startx(1) or xinit(1), the definition should be
at the top of your
.I .xinitrc
file.  If you use xdm(1), the definitions should be early on in the
.I __projectroot__/lib/X11/xdm/Xsession
script.
.SH OPTIONS
.B __xservername__
supports several mechanisms for supplying/obtaining configuration and
run-time parameters: command line options, environment variables, the
__xconfigfile__(__filemansuffix__) configuration file, auto-detection, and
fallback defaults.  When the same information is supplied in more than
one way, the highest precedence mechanism is used.  The list of mechanisms
is ordered from highest precedence to lowest.  Note that not all parameters
can be supplied via all methods.  The available command line options
and environment variables (and some defaults) are described here and in
the Xserver(1) manual page.  Most configuration file parameters, with
their defaults, are described in the __xconfigfile__(__filemansuffix__) manual
page.  Driver and module specific configuration parameters are described
in the relevant driver or module manual page.
.PP
In addition to the normal server options described in the Xserver(1)
manual page,
.B __xservername__
accepts the following command line switches:
.TP 8
.BI vt XX
.I XX
specifies the Virtual Terminal device number which
.B __xservername__
will use.  Without this option,
.B __xservername__
will pick the first available Virtual Terminal that it can locate.  This
option applies only to platforms such as Linux, BSD, SVR3 and SVR4, that
have virtual terminal support.
.TP
.B \-allowMouseOpenFail
Allow the server to start up even if the mouse device can't be opened
or initialised.  This is equivalent to the
.B AllowMouseOpenFail
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B \-allowNonLocalModInDev
Allow changes to keyboard and mouse settings from non-local clients.
By default, connections from non-local clients are not allowed to do
this.  This is equivalent to the
.B AllowNonLocalModInDev
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B \-allowNonLocalXvidtune
Make the VidMode extension available to remote clients.  This allows
the xvidtune client to connect from another host.  This is equivalent
to the
.B AllowNonLocalXvidtune
__xconfigfile__(__filemansuffix__) file option.  By default non-local
connections are not allowed.
.TP 8
.BI \-bgamma " value"
Set the blue gamma correction.
.I value
must be between 0.1 and 10.
The default is 1.0.  Not all drivers support this.  See also the
.BR \-gamma ,
.BR \-rgamma ,
and
.B \-ggamma
options.
.TP 8
.BI \-bpp " n"
No longer supported.  Use
.B \-depth
to set the color depth, and use
.B \-fbbpp
if you really need to force a non-default framebuffer (hardware) pixel
format.
.TP
.B \-configure
When this option is specified, the
.B __xservername__
server loads all video driver modules, probes for available hardware,
and writes out an initial __xconfigfile__(__filemansuffix__) file based on
what was detected.  This option currently has some problems on some
platforms, but in most cases it is a good way to bootstrap the
configuration process.  This option is only available when the server
is run as root (i.e, with real-uid 0).
.TP 8
.BI "\-crt /dev/tty" XX
SCO only.  This is the same as the
.B vt
option, and is provided for compatibility with the native SCO X server.
.TP 8
.BI \-depth " n"
Sets the default color depth.  Legal values are 1, 4, 8, 15, 16, and
24.  Not all drivers support all values.
.TP 8
.B \-disableModInDev
Disable dynamic modification of input device settings.  This is equivalent
to the
.B DisableModInDev
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B \-disableVidMode
Disable the the parts of the VidMode extension (used by the xvidtune
client) that can be used to change the video modes.  This is equivalent
to the
.B DisableVidModeExtension
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B \-fbbpp \fIn\fP
Sets the number of framebuffer bits per pixel.  You should only set this
if you're sure it's necessary; normally the server can deduce the correct
value from
.B \-depth
above.  Useful if you want to run a depth 24 configuration with a 24
bpp framebuffer rather than the (possibly default) 32 bpp framebuffer
(or vice versa).  Legal values are 1, 8, 16, 24, 32.  Not all drivers
support all values.
.TP 8
.B \-flipPixels
Swap the default values for the black and white pixels.
.TP 8
.BI \-gamma " value"
Set the gamma correction.
.I value
must be between 0.1 and 10.  The default is 1.0.  This value is applied
equally to the R, G and B values.  Those values can be set independently
with the
.BR \-rgamma ,
.BR \-bgamma ,
and
.B \-ggamma
options.  Not all drivers support this.
.TP 8
.BI \-ggamma " value"
Set the green gamma correction.
.I value
must be between 0.1 and 10.  The default is 1.0.  Not all drivers support
this.  See also the
.BR \-gamma ,
.BR \-rgamma ,
and
.B \-bgamma
options.
.TP 8
.B \-ignoreABI
The
.B __xservername__
server checks the ABI revision levels of each module that it loads.  It
will normally refuse to load modules with ABI revisions that are newer
than the server's.  This is because such modules might use interfaces
that the server does not have.  When this option is specified, mismatches
like this are downgraded from fatal errors to warnings.  This option
should be used with care.
.TP 8
.B \-isolateDevice \fIbus\-id\fP
Restrict device resets to the device at
.IR bus\-id .
The
.I bus\-id
string has the form
.IB bustype : bus : device : function
(e.g., \(oqPCI:1:0:0\(cq).
At present, only isolation of PCI devices is supported; i.e., this option
is ignored if
.I bustype
is anything other than \(oqPCI\(cq.
.TP 8
.B \-keeptty
Prevent the server from detaching its initial controlling terminal.
This option is only useful when debugging the server.  Not all platforms
support (or can use) this option.
.TP 8
.BI \-keyboard " keyboard-name"
Use the __xconfigfile__(__filemansuffix__) file
.B InputDevice
section called
.I keyboard-name
as the core keyboard.  This option is ignored when the
.B Layout
section specifies a core keyboard.  In the absence of both a Layout
section and this option, the first relevant
.B InputDevice
section is used for the core keyboard.
.TP 8
.BI \-layout " layout-name"
Use the __xconfigfile__(__filemansuffix__) file
.B Layout
section called
.IR layout-name .
By default the first
.B Layout
section is used.
.TP 8
.BI \-logfile " filename"
Use the file called
.I filename
as the
.B __xservername__
server log file.  The default log file is
.BI __logdir__/__xservername__. n .log
on most platforms, where
.I n
is the display number of the
.B __xservername__
server.  The default may be in a different directory on some platforms.
This option is only available when the server is run as root (i.e, with
real-uid 0).
.TP 8
.BR \-logverbose " [\fIn\fP]"
Sets the verbosity level for information printed to the
.B __xservername__
server log file.  If the
.I n
value isn't supplied, each occurrence of this option increments the log
file verbosity level.  When the
.I n
value is supplied, the log file verbosity level is set to that value.
The default log file verbosity level is 3.
.TP 8
.BI \-modulepath " searchpath"
Set the module search path to
.IR searchpath .
.I searchpath
is a comma separated list of directories to search for
.B __xservername__
server modules.  This option is only available when the server is run
as root (i.e, with real-uid 0).
.TP 8
.B \-nosilk
Disable Silken Mouse support.
.TP 8
.B \-pixmap24
Set the internal pixmap format for depth 24 pixmaps to 24 bits per pixel.
The default is usually 32 bits per pixel.  There is normally little
reason to use this option.  Some client applications don't like this
pixmap format, even though it is a perfectly legal format.  This is
equivalent to the
.B Pixmap
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B \-pixmap32
Set the internal pixmap format for depth 24 pixmaps to 32 bits per pixel.
This is usually the default.  This is equivalent to the
.B Pixmap
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.BI \-pointer " pointer-name"
Use the __xconfigfile__(__filemansuffix__) file
.B InputDevice
section called
.I pointer-name
as the core pointer.  This option is ignored when the
.B Layout
section specifies a core pointer.  In the absence of both a Layout
section and this option, the first relevant
.B InputDevice
section is used for the core pointer.
.TP 8
.B \-probeonly
Causes the server to exit after the device probing stage.  The
__xconfigfile__(__filemansuffix__) file is still used when this option is
given, so information that can be auto-detected should be commented out.
.TP 8
.B \-quiet
Suppress most informational messages at startup.  The verbosity level
is set to zero.
.TP 8
.BI \-rgamma " value"
Set the red gamma correction.
.I value
must be between 0.1 and 10.  The default is 1.0.  Not all drivers support
this.  See also the
.BR \-gamma ,
.BR \-bgamma ,
and
.B \-ggamma
options.
.TP 8
.B \-scanpci
When this option is specified, the
.B __xservername__
server scans the PCI bus, and prints out some information about each
device that was detected.  See also scanpci(1) and pcitweak(1).
.TP 8
.BI \-screen " screen-name"
Use the __xconfigfile__(__filemansuffix__) file
.B Screen
section called
.IR screen-name .
By default the screens referenced by the default
.B Layout
section are used, or the first
.B Screen
section when there are no
.B Layout
sections.
.TP 8
.B \-showconfig
This is the same as the
.B \-version
option, and is included for compatibility reasons.  It may be removed
in a future release, so the
.B \-version
option should be used instead.
.TP 8
.BI \-weight " nnn"
Set RGB weighting at 16 bpp.  The default is 565.  This applies only to
those drivers which support 16 bpp.
.TP 8
.BR \-verbose " [\fIn\fP]"
Sets the verbosity level for information printed on stderr.  If the
.I n
value isn't supplied, each occurrence of this option increments the
verbosity level.  When the
.I n
value is supplied, the verbosity level is set to that value.  The default
verbosity level is 0.
.TP 8
.B \-version
Print out the server version, patchlevel, release date, the operating
system/platform it was built on, and whether it includes module loader
support.
.TP 8
.BI \-config " file"
Read the server configuration from
.IR file .
This option will work for any file when the server is run as root (i.e,
with real-uid 0), or for files relative to a directory in the config
search path for all other users.
.SH "KEYBOARD"
.PP
The
.B __xservername__
server is normally configured to recognize various special combinations
of key presses that instruct the server to perform some action, rather
than just sending the key press event to a client application.  The
default XKEYBOARD keymap defines the key combinations listed below.
The server also has these key combinations builtin to its event handler
for cases where the XKEYBOARD extension is not being used.  When using
the XKEYBOARD extension, which key combinations perform which actions
is completely configurable.
.PP
For more information about when the builtin event handler
is used to recognize the special key combinations, see
the documentation on the
.B HandleSpecialKeys
option in the __xconfigfile__(__filemansuffix__) man page.
.PP
The special combinations of key presses recognized directly
by
.B __xservername__
are:
.TP 8
.B Ctrl+Alt+Backspace
Immediately kills the server -- no questions asked.  This can be disabled
with the
.B DontZap
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Plus
Change video mode to next one specified in the configuration file.
This can be disabled with the
.B DontZoom
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Minus
Change video mode to previous one specified in the configuration file.
This can be disabled with the
.B DontZoom
__xconfigfile__(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Multiply
Not treated specially by default.  If the
.B AllowClosedownGrabs
__xconfigfile__(__filemansuffix__) file option is specified, this key sequence
kills clients with an active keyboard or mouse grab as well as killing any
application that may have locked the server, normally using the
XGrabServer(__libmansuffix__) Xlib function.
.TP 8
.B Ctrl+Alt+Keypad-Divide
Not treated specially by default.  If the
.B AllowDeactivateGrabs
__xconfigfile__(__filemansuffix__) file option is specified, this key sequence
deactivates any active keyboard and mouse grabs.
.TP 8
.B Ctrl+Alt+F1...F12
For BSD and Linux systems with virtual terminal support, these keystroke
combinations are used to switch to virtual terminals 1 through 12,
respectively.  This can be disabled with the
.B DontVTSwitch
__xconfigfile__(__filemansuffix__) file option.
.SH CONFIGURATION
.B __xservername__
typically uses a configuration file called
.B __xconfigfile__
for its initial setup.
Refer to the __xconfigfile__(__filemansuffix__) manual page for information
about the format of this file.
.PP
Starting with version 4.4,
.B __xservername__
has a mechanism for automatically generating a built-in configuration
at run-time when no
.B __xconfigfile__
file is present.  The current version of this automatic configuration
mechanism works in three ways.
.PP
The first is via enhancements that have made many components of the
.B __xconfigfile__
file optional.  This means that information that can be probed or
reasonably deduced doesn't need to be specified explicitly, greatly
reducing the amount of built-in configuration information that needs to
be generated at run-time.
.PP
The second is to use an external utility called getconfig(1), when
available, to use meta-configuration information to generate a suitable
configuration for the primary video device.  The meta-configuration
information can be updated to allow an existing installation to get the
best out of new hardware or to work around bugs that are found
post-release.
.PP
The third is to have "safe" fallbacks for most configuration information.
This maximises the likelihood that the
.B __xservername__
server will start up in some usable configuration even when information
about the specific hardware is not available.
.PP
The automatic configuration support for __xservername__ is work in progress.
It is currently aimed at the most popular hardware and software platforms
supported by __xservername__.  Enhancements are planned for future releases.
.SH FILES
The
.B __xservername__
server config file can be found in a range of locations.  These are
documented fully in the __xconfigfile__(__filemansuffix__) manual page.  The
most commonly used locations are shown here.
.TP 30
.B /etc/X11/__xconfigfile__
Server configuration file.
.TP 30
.B /etc/X11/__xconfigfile__-4
Server configuration file.
.TP 30
.B /etc/__xconfigfile__
Server configuration file.
.TP 30
.B __projectroot__/etc/__xconfigfile__
Server configuration file.
.TP 30
.B __projectroot__/lib/X11/__xconfigfile__
Server configuration file.
.TP 30
.BI __logdir__/__xservername__. n .log
Server log file for display
.IR n .
.TP 30
.B __projectroot__/bin/\(**
Client binaries.
.TP 30
.B __projectroot__/include/\(**
Header files.
.TP 30
.B __projectroot__/lib/\(**
Libraries.
.TP 30
.B __projectroot__/lib/X11/fonts/\(**
Fonts.
.TP 30
.B __projectroot__/lib/X11/rgb.txt
Color names to RGB mapping.
.TP 30
.B __projectroot__/lib/X11/XErrorDB
Client error message database.
.TP 30
.B __projectroot__/lib/X11/app-defaults/\(**
Client resource specifications.
.TP 30
.B __projectroot__/man/man?/\(**
Manual pages.
.TP 30
.BI /etc/X n .hosts
Initial access control list for display
.IR n .
.SH "SEE ALSO"
X(__miscmansuffix__), Xserver(__appmansuffix__), xdm(__appmansuffix__), xinit(__appmansuffix__),
__xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), xorgcfg(__appmansuffix__), xvidtune(__appmansuffix__),
apm(__drivermansuffix__),
ati(__drivermansuffix__),
chips(__drivermansuffix__),
cirrus(__drivermansuffix__),
cyrix(__drivermansuffix__),
fbdev(__drivermansuffix__),
glide(__drivermansuffix__),
glint(__drivermansuffix__),
i128(__drivermansuffix__),
i740(__drivermansuffix__),
i810(__drivermansuffix__),
imstt(__drivermansuffix__),
mga(__drivermansuffix__),
neomagic(__drivermansuffix__),
nsc(__drivermansuffix__),
nv(__drivermansuffix__),
r128(__drivermansuffix__),
rendition(__drivermansuffix__),
s3virge(__drivermansuffix__),
siliconmotion(__drivermansuffix__),
sis(__drivermansuffix__),
sunbw2(__drivermansuffix__),
suncg14(__drivermansuffix__),
suncg3(__drivermansuffix__),
suncg6(__drivermansuffix__),
sunffb(__drivermansuffix__),
sunleo(__drivermansuffix__),
suntcx(__drivermansuffix__),
tdfx(__drivermansuffix__),
tga(__drivermansuffix__),
trident(__drivermansuffix__),
tseng(__drivermansuffix__),
v4l(__drivermansuffix__),
vesa(__drivermansuffix__),
vga(__drivermansuffix__),
vmware(__drivermansuffix__),
.br
Web site
.IR <http://www.x.org> .

.SH AUTHORS
__xservername__ has many contributors world wide.  The names of most of them
can be found in the documentation, CHANGELOG files in the source tree,
and in the actual source code.
.PP
__xservername__ was originally based on XFree86 4.4rc2.
That was originally based on \fIX386 1.2\fP by Thomas Roell, which
was contributed to the then X Consortium's X11R5 distribution by SGCS.
.PP
__xservername__ is released by the X.org Foundation.
.PP
The project that became XFree86 was originally founded in 1992 by
David Dawes, Glenn Lai, Jim Tsillas and David Wexelblat.
.PP
XFree86 was later integrated in the then X Consortium's X11R6 release
by a group of dedicated XFree86 developers, including the following:
.PP
.RS 4
.nf
Stuart Anderson    \fIanderson@metrolink.com\fP
Doug Anson         \fIdanson@lgc.com\fP
Gertjan Akkerman   \fIakkerman@dutiba.twi.tudelft.nl\fP
Mike Bernson       \fImike@mbsun.mlb.org\fP
Robin Cutshaw      \fIrobin@XFree86.org\fP
David Dawes        \fIdawes@XFree86.org\fP
Marc Evans         \fImarc@XFree86.org\fP
Pascal Haible      \fIhaible@izfm.uni-stuttgart.de\fP
Matthieu Herrb     \fIMatthieu.Herrb@laas.fr\fP
Dirk Hohndel       \fIhohndel@XFree86.org\fP
David Holland      \fIdavidh@use.com\fP
Alan Hourihane     \fIalanh@fairlite.demon.co.uk\fP
Jeffrey Hsu        \fIhsu@soda.berkeley.edu\fP
Glenn Lai          \fIglenn@cs.utexas.edu\fP
Ted Lemon          \fImellon@ncd.com\fP
Rich Murphey       \fIrich@XFree86.org\fP
Hans Nasten        \fInasten@everyware.se\fP
Mark Snitily       \fImark@sgcs.com\fP
Randy Terbush      \fIrandyt@cse.unl.edu\fP
Jon Tombs          \fItombs@XFree86.org\fP
Kees Verstoep      \fIversto@cs.vu.nl\fP
Paul Vixie         \fIpaul@vix.com\fP
Mark Weaver        \fIMark_Weaver@brown.edu\fP
David Wexelblat    \fIdwex@XFree86.org\fP
Philip Wheatley    \fIPhilip.Wheatley@ColumbiaSC.NCR.COM\fP
Thomas Wolfram     \fIwolf@prz.tu-berlin.de\fP
Orest Zborowski    \fIorestz@eskimo.com\fP
.fi
.RE
.PP
__xservername__ source is available from the FTP server
\fI<ftp://ftp.x.org/>\fP, and from the X.org
server \fI<http://www.freedesktop.org/cvs/>\fP.  Documentation and other
information can be found from the X.org web site
\fI<http://www.x.org/>\fP.

.SH LEGAL
.PP
.B __xservername__
is copyright software, provided under licenses that permit modification
and redistribution in source and binary form without fee.  
.B __xservername__ is copyright by numerous authors and
contributors from around the world.  Licensing information can be found
at
.IR <http://www.x.org> .
Refer to the source code for specific copyright notices.
.PP
.B XFree86(TM)
is a trademark of The XFree86 Project, Inc.
.PP
.B X11(TM)
and 
.B X Window System(TM)
are trademarks of The Open Group.
