'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbUpdateMapFromCore __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbUpdateMapFromCore \-  Update a local Xkb keyboard map to reflect the mapping 
expressed by a core format mapping
.SH SYNOPSIS
.B Bool XkbUpdateMapFromCore
(
.I xkb,
.I first_key,
.I num_keys,
.I map_width,
.I core_keysyms,
.I changes
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      KeyCode \fIfirst_key\fP\^;
.br
      int \fInum_keys\fP\^;
.br
      int \fImap_width\fP\^;
.br
      KeySym * \fIcore_keysyms\fP\^;
.br
      XkbChangesPtr \fIchanges\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description to update
.TP
.I \- first_key
keycode of first key description to update
.TP
.I \- num_keys
number of key descriptions to update
.TP
.I \- map_width
width of core protocol keymap
.TP
.I \- core_keysyms
symbols in core protocol keymap
.TP
.I \- changes
backfilled with changes made to Xkb
.SH DESCRIPTION
.LP
Xkb provides several functions that make it easier to apply the compatibility 
map to configure a client-side Xkb keyboard mapping, given a core protocol 
representation of part or all of a keyboard mapping. Obtain a core protocol 
representation of a keyboard mapping from an actual server (by using
.I XGetKeyboardMapping, 
for example), a data file, or some other source.

.I XkbUpdateMapFromCore 
interprets input argument information representing a keyboard map in core format 
to update the Xkb keyboard description passed in 
.I xkb. 
Only a portion of the Xkb map is updated - the portion corresponding to keys 
with keycodes in the range 
.I first_key 
through 
.I first_key + num_keys - 1. 
If 
.I XkbUpdateMapFromCore 
is being called in response to a MappingNotify event, 
.I first_key 
and 
.I num_keys 
are reported in the MappingNotify event. 
.I core_keysyms 
contains the keysyms corresponding to the keycode range being updated, in core 
keyboard description order. 
.I map_width 
is the number of keysyms per key in 
.I core_keysyms. 
Thus, the first 
.I map_width 
entries in 
.I core_keysyms 
are for the key with keycode 
.I first_key, 
the next 
.I map_width 
entries are for key 
.I first_key + 1, 
and so on.

In addition to modifying the Xkb keyboard mapping in 
.I xkb, XkbUpdateMapFromCore 
backfills the changes structure whose address is passed in 
.I changes 
to indicate the modifications that were made. You may then use 
.I changes 
in subsequent calls such as 
.I XkbSetMap, 
to propagate the local modifications to a server.
.SH "SEE ALSO"
.BR XkbSetMap (__libmansuffix__)
