.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XAllocClassHint 3X11 "Release 6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XAllocClassHint, XSetClassHint, XGetClassHint, XClassHint \- allocate class hints structure and set or read a window's WM_CLASS property
.SH SYNTAX
XClassHint *XAllocClassHint\^(\|)
.LP
XSetClassHint\^(\^\fIdisplay\fP, \fIw\fP, \fIclass_hints\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      XClassHint *\fIclass_hints\fP\^;
.LP
Status XGetClassHint\^(\^\fIdisplay\fP, \fIw\fP, \fIclass_hints_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP;
.br
      XClassHint *\fIclass_hints_return\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIclass_hints\fP 1i
Specifies the
.ZN XClassHint
structure that is to be used.
.IP \fIclass_hints_return\fP 1i
Returns the 
.ZN XClassHint
structure.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.ZN XAllocClassHint
function allocates and returns a pointer to a
.ZN XClassHint
structure.
Note that the pointer fields in the
.ZN XClassHint
structure are initially set to NULL.
If insufficient memory is available, 
.ZN XAllocClassHint
returns NULL.
To free the memory allocated to this structure,
use
.ZN XFree .
.LP
The
.ZN XSetClassHint
function sets the class hint for the specified window.
If the strings are not in the Host Portable Character Encoding,
the result is implementation dependent.
.LP
.ZN XSetClassHint
can generate
.ZN BadAlloc
and
.ZN BadWindow
errors.
.LP
The
.ZN XGetClassHint
function returns the class hint of the specified window to the members
of the supplied structure.
If the data returned by the server is in the Latin Portable Character Encoding,
then the returned strings are in the Host Portable Character Encoding.
Otherwise, the result is implementation dependent.
It returns a nonzero status on success;
otherwise, it returns a zero status.
To free res_name and res_class when finished with the strings,
use
.ZN XFree
on each individually.
.LP
.ZN XGetClassHint
can generate a
.ZN BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_CLASS\s+1
Set by application programs to allow window and session
managers to obtain the application's resources from the resource database.
.SH STRUCTURES
The
.ZN XClassHint
structure contains:
.LP
.IN "XClassHint" "" "@DEF@"
.Ds 0
.TA .5i
.ta .5i
typedef struct {
	char *res_name;
	char *res_class;
} XClassHint;
.De
.LP
The res_name member contains the application name, 
and the res_class member contains the application class. 
Note that the name set in this property may differ from the name set as WM_NAME.
That is, WM_NAME specifies what should be displayed in the title bar and,
therefore, can contain temporal information (for example, the name of
a file currently in an editor's buffer).
On the other hand, 
the name specified as part of WM_CLASS is the formal name of the application
that should be used when retrieving the application's resources from the 
resource database.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocIconSize(3X11),
XAllocSizeHints(3X11),
XAllocWMHints(3X11),
XFree(3X11),
XSetCommand(3X11),
XSetTransientForHint(3X11),
XSetTextProperty(3X11),
XSetWMClientMachine(3X11),
XSetWMColormapWindows(3X11),
XSetWMIconName(3X11),
XSetWMName(3X11),
XSetWMProperties(3X11),
XSetWMProtocols(3X11),
XStringListToTextProperty(3X11)
.br
\fI\*(xL\fP
