.ds xL AFlib \- C Language AF Interface
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
.tm \\n%:\\$1:\\$2:\\$3
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de PN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AFFlush 3 "Release 1" "AF Version 3" 
.SH NAME
\fBAFFlush, AFSync, AFEventsQueued, AFPending\fP \- handle output buffer or event queue
.SH SYNTAX
\fB#include <AF/AFlib.h>\fP
.LP
void \fBAFFlush\fP(AFAudioConn \fI*aud\fP)
.LP
void \fBAFSync\fP(AFAudioConn \fI*aud\fP, ABool \fIdiscard\fP)
.LP
int \fBAFEventsQueued\fP (AFAudioConn \fI*aud\fP, int \fImode\fP)
.LP
int \fBAFPending\fP (AFAudioConn \fI*aud\fP)
.SH ARGUMENTS
.IP \fIdiscard\fP 1i
Specifies a boolean value that indicates whether 
.PN AFSync
discards all events on the event queue.
.IP \fIaud\fP 1i
Specifies the connection to the AF server.
.IP \fImode\fP 1i
Specifies the mode.
You can pass
.PN QueuedAlready ,
.PN QueuedAfterFlush ,
or
.PN QueuedAfterReading .
.SH DESCRIPTION
The
.PN AFFlush
function
flushes the output buffer.
Most client applications need not use this function because the output
buffer is automatically flushed as needed by calls to
.PN AFPending
and
.PN AFNextEvent.
Events generated by the server may be enqueued into the library's event queue.
.LP
The
.PN AFSync
function
flushes the output buffer and then waits until all requests have been received
and processed by the AF server.
Any errors generated must be handled by the error handler.
For each error event received by AFlib,
.PN AFSync
calls the client application's error handling routine.
Any events generated by the server are enqueued into the library's 
event queue.
.LP
If \fIdiscard\fP is passed
.PN False,
.PN AFSync
does not discard the events in the queue.
If you passed 
.PN True,
.PN AFSync 
discards all events in the queue,
including those events that were on the queue before
.PN AFSync
was called.
Client applications seldom need to call
.PN AFSync .
.LP
If mode is 
.PN QueuedAlready ,
.PN AFEventsQueued 
returns the number of events
already in the event queue (and never performs a system call).
If mode is 
.PN QueuedAfterFlush , 
.PN AFEventsQueued
returns the number of events already in the queue if the number is nonzero.
If there are no events in the queue, 
.PN AFEventsQueued
flushes the output buffer, 
attempts to read more events out of the application's connection,
and returns the number read.
If mode is 
.PN QueuedAfterReading , 
.PN AFEventsQueued
returns the number of events already in the queue if the number is nonzero. 
If there are no events in the queue, 
.PN AFEventsQueued
attempts to read more events out of the application's connection 
without flushing the output buffer and returns the number read.
.LP
.PN AFEventsQueued
always returns immediately without I/O if there are events already in the
queue.
.PN AFEventsQueued
with mode 
.PN QueuedAfterFlush
is identical in behavior to
.PN AFPending .
.PN AFEventsQueued
with mode
.PN QueuedAlready
is identical to the
.PN AFQLength
function.
.LP
The
.PN AFPending
function returns the number of events that have been received from the
AF server but have not been removed from the event queue.
.PN AFPending
is identical to
.PN AFEventsQueued
with the mode
.PN QueuedAfterFlush
specified.
.SH "SEE ALSO"
AFIfEvent(3),
AFNextEvent(3)

.SH BUGS
If you encounter a \fBreproducible\fP bug, please 
submit a problem report to (af-bugs@crl.dec.com).
.SH COPYRIGHT
Copyright 1990-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Digital Cambridge Research Lab
