.\" Copyright (c) 1996  The XFree86 Project
.\" $XFree86: xc/programs/Xserver/hw/xfree86/doc/man/XF86DGA.man,v 3.5.2.2 1998/02/26 13:59:04 dawes Exp $
.\" $Xorg: XF86DGA.man,v 1.3 2000/08/17 19:50:53 cpqbld Exp $
.\" 
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.TH XF86DGA 3X11 "3.3.2" "XFree86" "X FUNCTIONS"
.SH NAME
XF86DGAQueryExtension, XF86DGAQueryVersion, XF86DGAQueryDirectVideo, XF86DGAGetVideo, XF86DGADirectVideo, XF86DGASetVidPage, XF86DGASetViewPort, XF86DGAViewPortChanged, XF86DGAGetViewPortSize, XF86DGAInstallColormap, XF86DGAForkApp \- XFree86-DGA extension interface functions
.SH SYNTAX
.nf
.LP
#include <X11/extensions/xf86dga.h>
.LP
Bool XF86DGAQueryExtension(
    Display *\fIdisplay\fP\^,
    int *\fIevent_base_return\fP\^,
    int *\fIerror_base_return\fP\^);
.LP
Bool XF86DGAQueryVersion(
    Display *\fIdisplay\fP\^,
    int *\fImajor_version_return\fP\^,
    int *\fIminor_version_return\fP\^);
.LP
Bool XF86DGAQueryDirectVideo(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIflags_return\fP\^);
.LP
Bool XF86DGAGetVideo(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    char **\fIaddr_return\fP\^,
    int *\fIwidth_return\fP\^,
    int *\fIbanksize_return\fP\^,
    int *\fImemsize_return\fP\^);
.LP
Bool XF86DGADirectVideo(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIflags\fP\^);
.LP
Bool XF86DGASetVidPage(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIpage\fP\^);
.LP
Bool XF86DGASetViewPort(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIx\fP\^,
    int \fIy\fP\^);
.LP
Bool XF86DGAViewPortChanged(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fInum_pages\fP\^);
.LP
Bool XF86DGAGetViewPortSize(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIviewport_width_return\fP\^,
    int *\fIviewport_height_return\fP\^);
.LP
Bool XF86DGAInstallColormap(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    Colormap \fIcmap\fP\^);
.LP
int XF86DGAForkApp(
    int \fIscreen\fP\^);
.fi
.SH ARGUMENTS
.IP \fIdisplay\fP 2i
Specifies the connection to the X server.
.IP \fIscreen\fP 2i
Specifies which screen number the setting apply to.
.IP \fIevent_base_return\fP 2i
Returns the base event number for the extension.
.IP \fIerror_base_return\fP 2i
Returns the base error number for the extension.
.IP \fImajor_version_return\fP 2i
Returns the major version number of the extension.
.IP \fIminor_version_return\fP 2i
Returns the minor version number of the extension.
.IP \fIaddr_return\fP 2i
Returns a pointer to the start of the video framebuffer.
.IP \fIwidth_return\fP 2i
Returns the framebuffer line width.
.IP \fIbanksize_return\fP 2i
Returns the framebuffer bank size.
.IP \fImemsize_return\fP 2i
Returns the size of the framebuffer memory.
.IP \fIflags\fP 2i
Sets the DirectVideo access features.  When zero, DirectVideo mode is
disabled.  \fIflags\fP may be a a bit-wise combination of the following
values:
.nf
XF86DGADirectGraphics          enable Direct Video mode
XF86DGADirectMouse             enable reporting of pointer movement
                               as relative motion
XF86DGADirectKeyb              enable direct reporting of keyboard events
.fi
.IP \fIflags_return\fP 2i
Reports the DirectVideo features supported by the hardware.  When zero,
the hardware does not support direct video at all.
\fIflags\fP may be a a bit-wise combination of the following
values:
.nf
XF86DGADirectPresent           DirectVideo support is present
.fi
.IP \fIpage\fP 2i
Indicates the framebuffer page (bank) to activate for read/write access.
.IP \fIx\fP 2i
Incidates the x coordinate for the upper-left corner of the view port.
.IP \fIy\fP 2i
Incidates the y coordinate for the upper-left corner of the view port.
.IP \fIviewport_width_return\fP 2i
Reports the width of the view port.
.IP \fIviewport_width_return\fP 2i
Reports the height of the view port.
.IP \fInum_pages\fP 2i
Indicates the number of pages when doing hardware multi-buffering.
.IP \fIcmap\fP 2i
Indicates the colormap to install.
.SH DESCRIPTION
These functions provide an interface to the server extension
\fIXFree86-DGA\fP
which allows a local client direct access to the video framebuffer.
Applications that use these functions must be linked with
.ZN -lXxf86dga
.SS "DGA FUNCTIONS"
The function
.ZN XF86DGAQueryDirectVideo
returns the DirectVideo capabilities supported by the graphics device.
.PP
The
.ZN XF86DGAGetVideo
function is used to get the parameters for the framebuffer.  The parameters
returned are a pointer to the start of the framebuffer, the framebuffer line
width, framebuffer bank size, and framebuffer memory size.
.PP
.ZN XF86DGADirectVideo
is used to enable or disable DirectVideo mode.
.PP
The
.ZN XF86DGASetVidPage
function sets the currently active framebuffer page (bank).  This is only
required for hardware which has a banked memory layout (banksize < memsize).
.PP
The
.ZN XF86DGASetViewPort
function sets the framebuffer coordinates to use for the upper-left corner
of the view port.
.PP
The
.ZN XF86DGAViewPortChanged
function checks whether a previous XF86DGASetViewPort command has been
completed by the hardware, that is, whether a vertical retrace has
occurred since a previous XF86DGASetViewPort.  This can (must, in fact)
be used with page-flipping; you can start writing to the next page only
when this function returns TRUE.  For some devices this will be the case
immediately after XF86DGASetViewPort, however this may be changed in the
future.  The number of pages used is specified with \fInum_pages\fP; it
should be 2 for simple page flipping (double buffering).  If n is greater
than two (triple or multi-buffering), the function checks whether the
(n \- 2)-before-last SetViewPort has been completed.
.PP
The
.ZN XF86DGAGetViewPortSize
function returns the size of the view port, which is the part of the
framebuffer that is visible on the screen.
.PP
The
.ZN XF86DGAInstallColormap
function is used to install a colormap.  This must be called after DirectVideo
mode has been enabled.
.PP
The
.ZN XF86DGAForkApp
function causes the client application to fork, leaving the parent process
to hang around and return to non-DGA mode should the client exit for any
reason.  This function returns 0 for success, or the error condition
returned by fork().
.SS "OTHER FUNCTIONS"
The
.ZN XF86DGAQueryVersion
function can be used to determine the version of the extension
built into the server.
.PP
The function
.ZN XF86DGAQueryExtension
returns the lowest numbered error and event values
assigned to the extension.
.SH SEE ALSO
XFree86(1), XF86Config(4/5)
.SH AUTHORS
Jon Tombs, Harm Hanemaayer, Mark Vojkovich.

