.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XAllocIconSize 3X11 "Release 6.4" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XAllocIconSize, XSetIconSizes, XGetIconSizes, XIconSize \- allocate icon size structure and set or read a window's WM_ICON_SIZES property
.SH SYNTAX
XIconSize *XAllocIconSize\^(\|)
.LP
XSetIconSizes\^(\^\fIdisplay\fP, \fIw\fP, \fIsize_list\fP, \fIcount\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      XIconSize *\fIsize_list\fP\^;
.br
      int \fIcount\fP\^;
.LP
Status XGetIconSizes\^(\^\fIdisplay\fP, \fIw\fP, \fIsize_list_return\fP, \fIcount_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      XIconSize **\fIsize_list_return\fP\^;
.br
      int *\fIcount_return\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcount\fP 1i
Specifies the number of items in the size list.
.IP \fIcount_return\fP 1i
Returns the number of items in the size list.
.IP \fIsize_list\fP 1i
Specifies the size list.
.IP \fIsize_list_return\fP 1i
Returns the size list.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.ZN XAllocIconSize 
function allocates and returns a pointer to a
.ZN XIconSize 
structure.
Note that all fields in the
.ZN XIconSize
structure are initially set to zero.
If insufficient memory is available, 
.ZN XAllocIconSize
returns NULL.
To free the memory allocated to this structure,
use
.ZN XFree .
.LP
The
.ZN XSetIconSizes
function is used only by window managers to set the supported icon sizes.
.LP
.ZN XSetIconSizes
can generate
.ZN BadAlloc
and
.ZN BadWindow
errors.
.LP
The
.ZN XGetIconSizes
function returns zero if a window manager has not set icon sizes;
otherwise, it return nonzero.
.ZN XGetIconSizes
should be called by an application that
wants to find out what icon sizes would be most appreciated by the
window manager under which the application is running.
The application
should then use
.ZN XSetWMHints
to supply the window manager with an icon pixmap or window in one of the
supported sizes.
To free the data allocated in size_list_return, use
.ZN XFree .
.LP
.ZN XGetIconSizes
can generate a
.ZN BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_ICON_SIZES\s+1
The window manager may set this property on the root window to
specify the icon sizes it supports.
The C type of this property is 
.ZN XIconSize .
.SH STRUCTURES
The
.ZN XIconSize
structure contains:
.LP
.IN "XIconSize" "" "@DEF@"
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	int min_width, min_height;
	int max_width, max_height;
	int width_inc, height_inc;
} XIconSize;
.De
.LP
The width_inc and height_inc members define an arithmetic progression of
sizes (minimum to maximum) that represent the supported icon sizes.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(3X11),
XAllocSizeHints(3X11),
XAllocWMHints(3X11),
XFree(3X11),
XSetCommand(3X11),
XSetTransientForHint(3X11),
XSetTextProperty(3X11),
XSetWMClientMachine(3X11),
XSetWMColormapWindows(3X11),
XSetWMIconName(3X11),
XSetWMName(3X11),
XSetWMProperties(3X11),
XSetWMProtocols(3X11),
XStringListToTextProperty(3X11)
.br
\fI\*(xL\fP
