.TH RESIZE 1 "26 October 1988" "X Version 11"
.SH NAME
resize - utility to set TERMCAP and terminal settings to current window size
.SH SYNOPSIS
.B resize
[-u] [\-s [row col]]
.SH DESCRIPTION
.I Resize
prints a shell command for setting the TERM and TERMCAP environment variables
to indiciate the current size of \fIxterm\fP window from which the command
is run.  For this output to take effect, \fIresize\fP must either be evaluated
as part of the command line (usually done with a shell alias or function) or
else redirected to a file which can then be read in.  From the C shell (usually
known as \fI/bin/csh\fP), the following alias could be defined in the 
user's \fI.cshrc\fP:
.sp
.nf
        %  alias rs 'set noglob; `eval resize`'
.fi
.sp
After resizing the window, the user would type:
.sp
.nf
        %  rs
.fi
.sp
Users of versions of the Bourne shell (usually known as \fI/bin/sh\fP) that 
don't have command
functions will need to send the output to a temporary file and the read it back
in with the ``.'' command:
.sp
.nf
        $  resize >/tmp/out
        $  . /tmp/out
.fi
.SH OPTIONS
The following options may be used with \fIresize\fP:
.TP 8
.B \-u
This option indicates that Bourne shell commands should be generated even if 
the user's current shell isn't \fI/bin/sh\fP.
.TP 8
.B \-c
This option indicates that C shell commands should be generated even if the
user's current shell isn't \fI/bin/csh\fP.
.TP 8
.B \-s \fR[\fIrows columns\fP]
This option indicates that that Sun console escape sequences will be used 
instead of the special \fIxterm\fP escape code.  If \fIrows\fP and
\fIcolumns\fP are given, \fIresize\fP will ask the \fIxterm\fP to resize
itself.  However, the window manager may choose to disallow the change.
.SH FILES
/etc/termcap	for the base termcap entry to modify.
.br
~/.cshrc	user's alias for the command.
.SH "SEE ALSO"
csh(1), tset(1), xterm(1)
.SH AUTHORS
Mark Vandevoorde (MIT-Athena), Edward Moy (Berkeley)
.br
Copyright (c) 1984, 1985 by Massachusetts Institute of Technology.
.br
See
.IR X (1)
for a complete copyright notice.
.SH BUGS
The \fI-u\fP or \fI-c\fP must appear to the left of \fI-s\fP if both are 
specified.
.PP
There should be some global notion of display size; termcap and
terminfo need to be rethought in the context of window systems.
(Fixed in 4.3BSD, and Ultrix-32 1.2)
