/*****************************************************************************
 * accessor.c: accessors to members of dvdplay_ptr.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: accessor.c,v 1.6 2003/01/29 20:55:26 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

/*****************************************************************************
 * Preamble
 *****************************************************************************/

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif
#include <assert.h>

#include "common.h"

#include <dvdread/ifo_types.h>
#include <dvdread/nav_read.h>

#include "dvdplay/dvdplay.h"

#include "tools.h"
#include "command.h"
#include "vmg.h"

/*
 * dvdread
 */
/*****************************************************************************
 * dvdplay_dvdread:
 *****************************************************************************/
extern dvd_reader_t * dvdplay_dvdread( dvdplay_ptr dvdplay )
{
    return dvdplay->p_dvdread;
}

/*****************************************************************************
 * dvdplay_file:
 *****************************************************************************/
extern dvd_file_t * dvdplay_file( dvdplay_ptr dvdplay )
{
    return dvdplay->p_file;
}

/*****************************************************************************
 * dvdplay_vmgi:
 *****************************************************************************/
extern ifo_handle_t * dvdplay_vmgi( dvdplay_ptr dvdplay )
{
    return dvdplay->p_vmgi;
}

/*****************************************************************************
 * dvdplay_vtsi:
 *****************************************************************************/
extern ifo_handle_t * dvdplay_vtsi( dvdplay_ptr dvdplay )
{
    return dvdplay->p_vtsi;
}

/*
 * state
 */

/*****************************************************************************
 * dvdplay_state_block:
 *****************************************************************************/
extern int dvdplay_state_block( dvdplay_ptr dvdplay )
{
    return dvdplay->state.i_blockN;
}

/*****************************************************************************
 * dvdplay_state_cell:
 *****************************************************************************/
extern int dvdplay_state_cell( dvdplay_ptr dvdplay )
{
    return dvdplay->state.i_cellN;
}

/*****************************************************************************
 * dvdplay_state_pg:
 *****************************************************************************/
extern int dvdplay_state_pg( dvdplay_ptr dvdplay )
{
    return dvdplay->state.i_pgN;
}

/*****************************************************************************
 * dvdplay_state_pgc:
 *****************************************************************************/
extern int dvdplay_state_pgc( dvdplay_ptr dvdplay )
{
    return dvdplay->state.i_pgcN;
}

/*****************************************************************************
 * dvdplay_state_vts:
 *****************************************************************************/
extern int dvdplay_state_vts( dvdplay_ptr dvdplay )
{
    return dvdplay->state.i_vtsN;
}

/*****************************************************************************
 * dvdplay_state_pgc_t:
 *****************************************************************************/
extern pgc_t * dvdplay_state_pgc_t( dvdplay_ptr dvdplay )
{
    return dvdplay->state.p_pgc;
}

/*****************************************************************************
 * dvdplay_position:
 *****************************************************************************/
extern off_t dvdplay_position( dvdplay_ptr dvdplay )
{
    int i_block;

    i_block = dvdplay->state.p_pgc->cell_playback[
                  dvdplay->state.i_cellN - 1  ].first_sector
            + dvdplay->state.i_blockN;

    return i_block;
}

/*
 * ifo/registers
 */

/*****************************************************************************
 * dvdplay_still_time:
 *****************************************************************************/
extern int dvdplay_still_time( dvdplay_ptr dvdplay )
{
    return dvdplay->state.p_pgc->cell_playback[
            dvdplay->state.i_cellN - 1 ].still_time;
}
