/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.SunToolkit;
import sun.java2d.opengl.OGLRenderQueue;
import sun.security.action.GetIntegerAction;

public abstract class UNIXToolkit
extends SunToolkit {
    public static final Object GTK_LOCK = new Object();
    private static final int[] BAND_OFFSETS = new int[]{0, 1, 2};
    private static final int[] BAND_OFFSETS_ALPHA = new int[]{0, 1, 2, 3};
    private static final int DEFAULT_DATATRANSFER_TIMEOUT = 10000;
    private static Boolean nativeGTKAvailable = null;
    private BufferedImage tmpImage = null;
    public static final String FONTCONFIGAAHINT = "fontconfig/Antialias";

    public static int getDatatransferTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("sun.awt.datatransfer.timeout"));
        if (n == null || n <= 0) {
            return 10000;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkGTK() {
        Object object = GTK_LOCK;
        synchronized (object) {
            if (nativeGTKAvailable == null) {
                if (UNIXToolkit.load_gtk()) {
                    nativeGTKAvailable = Boolean.TRUE;
                } else {
                    UNIXToolkit.unloadGTK();
                    nativeGTKAvailable = Boolean.FALSE;
                }
            }
        }
        return nativeGTKAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadGTK() {
        Object object = GTK_LOCK;
        synchronized (object) {
            if (nativeGTKAvailable == Boolean.TRUE) {
                UNIXToolkit.unload_gtk();
            }
            nativeGTKAvailable = null;
        }
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith("gtk.icon.")) {
            return this.lazilyLoadGTKIcon(string);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected Object lazilyLoadGTKIcon(String string) {
        Object v = this.desktopProperties.get(string);
        if (v != null) {
            return v;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 5) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        GTKConstants.TextDirection textDirection = "ltr".equals(stringArray[4]) ? GTKConstants.TextDirection.LTR : GTKConstants.TextDirection.RTL;
        BufferedImage bufferedImage = this.getStockIcon(-1, stringArray[2], n, textDirection.ordinal(), null);
        if (bufferedImage != null) {
            this.setDesktopProperty(string, bufferedImage);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getGTKIcon(String string) {
        if (!UNIXToolkit.checkGTK()) {
            return null;
        }
        Object object = GTK_LOCK;
        synchronized (object) {
            if (!this.load_gtk_icon(string)) {
                this.tmpImage = null;
            }
        }
        return this.tmpImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getStockIcon(int n, String string, int n2, int n3, String string2) {
        if (!UNIXToolkit.checkGTK()) {
            return null;
        }
        Object object = GTK_LOCK;
        synchronized (object) {
            if (!this.load_stock_icon(n, string, n2, n3, string2)) {
                this.tmpImage = null;
            }
        }
        return this.tmpImage;
    }

    public void loadIconCallback(byte[] byArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.tmpImage = null;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n3 * n2);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n3, n5, bl ? BAND_OFFSETS_ALPHA : BAND_OFFSETS, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), bl, false, 3, 0);
        this.tmpImage = new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private static native boolean load_gtk();

    private static native boolean unload_gtk();

    private native boolean load_gtk_icon(String var1);

    private native boolean load_stock_icon(int var1, String var2, int var3, int var4, String var5);

    private native void nativeSync();

    public void sync() {
        this.nativeSync();
        OGLRenderQueue.sync();
    }

    protected RenderingHints getDesktopAAHints() {
        String string;
        Object object = this.getDesktopProperty("gnome.Xft/Antialias");
        if (object == null) {
            object = this.getDesktopProperty(FONTCONFIGAAHINT);
            if (object != null) {
                return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
            return null;
        }
        boolean bl = object instanceof Number && ((Number)object).intValue() != 0;
        Object object2 = bl ? ((string = (String)this.getDesktopProperty("gnome.Xft/RGBA")) == null || string.equals("none") ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : (string.equals("rgb") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB : (string.equals("bgr") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : (string.equals("vrgb") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB : (string.equals("vbgr") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_ON))))) : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
    }
}

