/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.ImmutableDescriptor;

public class MBeanFeatureInfo
implements Serializable,
DescriptorRead {
    static final long serialVersionUID = 3952882688968447265L;
    protected String name;
    protected String description;
    private transient Descriptor descriptor;

    public MBeanFeatureInfo(String string, String string2) {
        this(string, string2, null);
    }

    public MBeanFeatureInfo(String string, String string2, Descriptor descriptor) {
        this.name = string;
        this.description = string2;
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)ImmutableDescriptor.nonNullDescriptor(this.descriptor).clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanFeatureInfo)) {
            return false;
        }
        MBeanFeatureInfo mBeanFeatureInfo = (MBeanFeatureInfo)object;
        return mBeanFeatureInfo.getName().equals(this.getName()) && mBeanFeatureInfo.getDescription().equals(this.getDescription()) && ((Object)mBeanFeatureInfo.getDescriptor()).equals(this.getDescriptor());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDescription().hashCode() ^ ((Object)this.getDescriptor()).hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.descriptor != null && this.descriptor.getClass() == ImmutableDescriptor.class) {
            objectOutputStream.write(1);
            String[] stringArray = this.descriptor.getFieldNames();
            objectOutputStream.writeObject(stringArray);
            objectOutputStream.writeObject(this.descriptor.getFieldValues(stringArray));
        } else {
            objectOutputStream.write(0);
            objectOutputStream.writeObject(this.descriptor);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        switch (objectInputStream.read()) {
            case 1: {
                String[] stringArray = (String[])objectInputStream.readObject();
                if (stringArray.length == 0) {
                    this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                    break;
                }
                Object[] objectArray = (Object[])objectInputStream.readObject();
                this.descriptor = new ImmutableDescriptor(stringArray, objectArray);
                break;
            }
            case 0: {
                this.descriptor = (Descriptor)objectInputStream.readObject();
                if (this.descriptor != null) break;
                this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                break;
            }
            case -1: {
                this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                break;
            }
            default: {
                throw new StreamCorruptedException("Got unexpected byte.");
            }
        }
    }
}

