/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    public void setColorModel(ColorModel colorModel) {
        if (this.canFilterIndexColorModel && colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = this.filterIndexColorModel((IndexColorModel)colorModel);
            this.substituteColorModel(colorModel, indexColorModel);
            this.consumer.setColorModel(indexColorModel);
        } else {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void substituteColorModel(ColorModel colorModel, ColorModel colorModel2) {
        this.origmodel = colorModel;
        this.newmodel = colorModel2;
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        indexColorModel.getAlphas(byArray4);
        int n2 = indexColorModel.getTransparentPixel();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n3 = this.filterRGB(-1, -1, indexColorModel.getRGB(i));
            byArray4[i] = (byte)(n3 >> 24);
            if (byArray4[i] != -1 && i != n2) {
                bl = true;
            }
            byArray[i] = (byte)(n3 >> 16);
            byArray2[i] = (byte)(n3 >> 8);
            byArray3[i] = (byte)(n3 >> 0);
        }
        if (bl) {
            return new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray2, byArray3, byArray4);
        }
        return new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray2, byArray3, n2);
    }

    public void filterRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n5;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[n7] = this.filterRGB(n + j, n2 + i, nArray[n7]);
                ++n7;
            }
            n7 += n6 - n3;
        }
        this.consumer.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, byArray, n5, n6);
        } else {
            int[] nArray = new int[n3];
            int n7 = n5;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray[j] = colorModel.getRGB(byArray[n7] & 0xFF);
                    ++n7;
                }
                n7 += n6 - n3;
                this.filterRGBPixels(n, n2 + i, n3, 1, nArray, 0, n3);
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, nArray, n5, n6);
        } else {
            int[] nArray2 = new int[n3];
            int n7 = n5;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[j] = colorModel.getRGB(nArray[n7]);
                    ++n7;
                }
                n7 += n6 - n3;
                this.filterRGBPixels(n, n2 + i, n3, 1, nArray2, 0, n3);
            }
        }
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

