/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.awt.X11ComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.OGLSurfaceData;

public abstract class GLXSurfaceData
extends OGLSurfaceData {
    protected X11ComponentPeer peer;
    private GLXGraphicsConfig graphicsConfig;

    private native void initOps(X11ComponentPeer var1, long var2);

    protected native boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    protected GLXSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig, ColorModel colorModel, int n) {
        super(gLXGraphicsConfig, colorModel, n);
        this.peer = x11ComponentPeer;
        this.graphicsConfig = gLXGraphicsConfig;
        this.initOps(x11ComponentPeer, this.graphicsConfig.getAData());
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static GLXWindowSurfaceData createData(X11ComponentPeer x11ComponentPeer) {
        GLXGraphicsConfig gLXGraphicsConfig = GLXSurfaceData.getGC(x11ComponentPeer);
        return new GLXWindowSurfaceData(x11ComponentPeer, gLXGraphicsConfig);
    }

    public static GLXOffScreenSurfaceData createData(X11ComponentPeer x11ComponentPeer, Image image, int n) {
        GLXGraphicsConfig gLXGraphicsConfig = GLXSurfaceData.getGC(x11ComponentPeer);
        Rectangle rectangle = x11ComponentPeer.getBounds();
        if (n == 4) {
            return new GLXOffScreenSurfaceData(x11ComponentPeer, gLXGraphicsConfig, rectangle.width, rectangle.height, image, x11ComponentPeer.getColorModel(), 4);
        }
        return new GLXVSyncOffScreenSurfaceData(x11ComponentPeer, gLXGraphicsConfig, rectangle.width, rectangle.height, image, x11ComponentPeer.getColorModel(), n);
    }

    public static GLXOffScreenSurfaceData createData(GLXGraphicsConfig gLXGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        return new GLXOffScreenSurfaceData(null, gLXGraphicsConfig, n, n2, image, colorModel, n3);
    }

    public static GLXGraphicsConfig getGC(X11ComponentPeer x11ComponentPeer) {
        if (x11ComponentPeer != null) {
            return (GLXGraphicsConfig)x11ComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (GLXGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    public static class GLXOffScreenSurfaceData
    extends GLXSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;

        public GLXOffScreenSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(x11ComponentPeer, gLXGraphicsConfig, colorModel, n3);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.initSurface(n, n2);
        }

        public SurfaceData getReplacement() {
            return GLXOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        public Rectangle getBounds() {
            if (this.type == 4) {
                Rectangle rectangle = this.peer.getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
                return rectangle;
            }
            return new Rectangle(this.width, this.height);
        }

        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class GLXVSyncOffScreenSurfaceData
    extends GLXOffScreenSurfaceData {
        private GLXOffScreenSurfaceData flipSurface;

        public GLXVSyncOffScreenSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(x11ComponentPeer, gLXGraphicsConfig, n, n2, image, colorModel, n3);
            this.flipSurface = GLXSurfaceData.createData(x11ComponentPeer, image, 4);
        }

        public SurfaceData getFlipSurface() {
            return this.flipSurface;
        }

        public void flush() {
            this.flipSurface.flush();
            super.flush();
        }
    }

    public static class GLXWindowSurfaceData
    extends GLXSurfaceData {
        public GLXWindowSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig) {
            super(x11ComponentPeer, gLXGraphicsConfig, x11ComponentPeer.getColorModel(), 1);
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }

        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

