/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.VersionHelper;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class VersionHelper12
extends VersionHelper {
    private static final String TRUST_URL_CODEBASE_PROPERTY = "com.sun.jndi.ldap.object.trustURLCodebase";
    private static final String trustURLCodebase = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            try {
                return System.getProperty(VersionHelper12.TRUST_URL_CODEBASE_PROPERTY, "false");
            }
            catch (SecurityException securityException) {
                return "false";
            }
        }
    });

    VersionHelper12() {
    }

    ClassLoader getURLClassLoader(String[] stringArray) throws MalformedURLException {
        ClassLoader classLoader = this.getContextClassLoader();
        if (stringArray != null && "true".equalsIgnoreCase(trustURLCodebase)) {
            return URLClassLoader.newInstance(VersionHelper12.getUrlArray(stringArray), classLoader);
        }
        return classLoader;
    }

    Class loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getContextClassLoader();
        return Class.forName(string, true, classLoader);
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    Thread createThread(final Runnable runnable) {
        return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Thread(runnable);
            }
        });
    }
}

