/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;

public final class DeploySigningCertStore
implements CertStore {
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private KeyStore _deploymentUserCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemCerts = CertUtils.createEmptyKeyStore();
    private char[] keyPassphrase = new char[0];
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    private DeploySigningCertStore(int n) {
        this.certStoreType = n;
    }

    public static CertStore getCertStore() {
        return new ImmutableCertStore(new DeploySigningCertStore(3));
    }

    public static CertStore getUserCertStore() {
        return new DeploySigningCertStore(1);
    }

    public static CertStore getSystemCertStore() {
        return new ImmutableCertStore(new DeploySigningCertStore(2));
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long l;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (l = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserCerts = this.loadCertStore(_userFilename, bl);
            this._userLastModified = l;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null && (l = CertUtils.getFileLastModified(_systemFilename)) != this._sysLastModified) {
            this._deploymentSystemCerts = this.loadCertStore(_systemFilename, bl);
            this._sysLastModified = l;
        }
    }

    private KeyStore loadCertStore(String string, final boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("deploycertstore.cert.loading", new Object[]{string});
        final File file = new File(string);
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        if (bl) {
                            DeploySigningCertStore.this.cancelFlag = false;
                            keyStore.load(bufferedInputStream, new char[0]);
                        } else {
                            keyStore.load(bufferedInputStream, null);
                        }
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                if (bl) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    CredentialInfo credentialInfo = UIFactory.showPasswordDialog(null, ResourceManager.getMessage("password.dialog.title"), ResourceManager.getMessage("deploycertstore.password.dialog.text"), false, false, null, false);
                    if (credentialInfo != null) {
                        this.cancelFlag = false;
                        this.keyPassphrase = credentialInfo.getPassword();
                        keyStore.load(bufferedInputStream, this.keyPassphrase);
                    } else {
                        this.cancelFlag = true;
                    }
                    bufferedInputStream.close();
                    fileInputStream.close();
                }
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.loaded", new Object[]{string});
        return keyStore;
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("deploycertstore.cert.saving", new Object[]{_userFilename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_userFilename);
                    file.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    DeploySigningCertStore.this._deploymentUserCerts.store(bufferedOutputStream, DeploySigningCertStore.this.keyPassphrase);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.saved", new Object[]{_userFilename});
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, false);
    }

    public boolean add(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.adding");
        if (this.cancelFlag) {
            return false;
        }
        String string = this._deploymentUserCerts.getCertificateAlias(certificate);
        boolean bl2 = true;
        if (string != null) {
            try {
                if (bl || string.indexOf("$tsflag") == -1) {
                    bl2 = false;
                } else {
                    this.remove(certificate);
                }
            }
            catch (IOException iOException) {
                Trace.securityPrintException(iOException);
            }
        }
        if (bl2) {
            Random random = new Random();
            String string2 = null;
            while (this._deploymentUserCerts.getCertificate(string2 = bl ? "deploymentusercert$tsflag" + random.nextLong() : "deploymentusercert" + random.nextLong()) != null) {
            }
            this._deploymentUserCerts.setCertificateEntry(string2, certificate);
            Trace.msgSecurityPrintln("deploycertstore.cert.added", new Object[]{string2});
        }
        return true;
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        if (this.cancelFlag) {
            return false;
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removing");
        String string = this._deploymentUserCerts.getCertificateAlias(certificate);
        if (string != null) {
            this._deploymentUserCerts.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removed", new Object[]{string});
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, false);
    }

    public boolean contains(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.instore");
        String string = this._deploymentUserCerts.getCertificateAlias(certificate);
        if (!(string == null || bl && string.indexOf("$tsflag") <= -1)) {
            return true;
        }
        string = this._deploymentSystemCerts.getCertificateAlias(certificate);
        return string != null && (!bl || string.indexOf("$tsflag") > -1);
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("deploycertstore.cert.canverify");
        return false;
    }

    public Collection getCertificates() throws KeyStoreException {
        HashSet hashSet = new HashSet();
        if ((this.certStoreType & 1) == 1) {
            hashSet.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            hashSet.addAll(this.getCertificates(2));
        }
        return hashSet;
    }

    private Collection getCertificates(int n) throws KeyStoreException {
        Object object;
        Trace.msgSecurityPrintln("deploycertstore.cert.getcertificates");
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        KeyStore keyStore = null;
        keyStore = n == 1 ? this._deploymentUserCerts : this._deploymentSystemCerts;
        Enumeration<String> enumeration = keyStore.aliases();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            treeSet.add(object);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            Certificate certificate = keyStore.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }

    static {
        _userFilename = Config.getUserTrustedCertificateFile();
        _systemFilename = Config.getSystemTrustedCertificateFile();
    }
}

