/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharsetMapping {
    public static final char UNMAPPABLE_DECODING = '\ufffd';
    public static final int UNMAPPABLE_ENCODING = 65533;
    char[] b2cSB;
    char[] b2cDB1;
    char[] b2cDB2;
    int b2Min;
    int b2Max;
    int b1MinDB1;
    int b1MaxDB1;
    int b1MinDB2;
    int b1MaxDB2;
    int dbSegSize;
    char[] c2b;
    char[] c2bIndex;
    char[] b2cSupp;
    char[] c2bSupp;
    Entry[] b2cComp;
    Entry[] c2bComp;
    static Comparator<Entry> comparatorBytes = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            return entry.bs - entry2.bs;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    static Comparator<Entry> comparatorCP = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            return entry.cp - entry2.cp;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    static Comparator<Entry> comparatorComp = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n = entry.cp - entry2.cp;
            if (n == 0) {
                n = entry.cp2 - entry2.cp2;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    private static final int MAP_SINGLEBYTE = 1;
    private static final int MAP_DOUBLEBYTE1 = 2;
    private static final int MAP_DOUBLEBYTE2 = 3;
    private static final int MAP_SUPPLEMENT = 5;
    private static final int MAP_SUPPLEMENT_C2B = 6;
    private static final int MAP_COMPOSITE = 7;
    private static final int MAP_INDEXC2B = 8;
    int off = 0;
    byte[] bb;

    public char decodeSingle(int n) {
        return this.b2cSB[n];
    }

    public char decodeDouble(int n, int n2) {
        if (n2 >= this.b2Min && n2 < this.b2Max) {
            n2 -= this.b2Min;
            if (n >= this.b1MinDB1 && n <= this.b1MaxDB1) {
                return this.b2cDB1[(n -= this.b1MinDB1) * this.dbSegSize + n2];
            }
            if (n >= this.b1MinDB2 && n <= this.b1MaxDB2) {
                return this.b2cDB2[(n -= this.b1MinDB2) * this.dbSegSize + n2];
            }
        }
        return '\ufffd';
    }

    public char[] decodeSurrogate(int n, char[] cArray) {
        int n2 = this.b2cSupp.length / 2;
        int n3 = Arrays.binarySearch(this.b2cSupp, 0, n2, (char)n);
        if (n3 >= 0) {
            Character.toChars(this.b2cSupp[n2 + n3] + 131072, cArray, 0);
            return cArray;
        }
        return null;
    }

    public char[] decodeComposite(Entry entry, char[] cArray) {
        int n = CharsetMapping.findBytes(this.b2cComp, entry);
        if (n >= 0) {
            cArray[0] = (char)this.b2cComp[n].cp;
            cArray[1] = (char)this.b2cComp[n].cp2;
            return cArray;
        }
        return null;
    }

    public int encodeChar(char c) {
        char c2 = this.c2bIndex[c >> 8];
        if (c2 == '\uffff') {
            return 65533;
        }
        return this.c2b[c2 + (c & 0xFF)];
    }

    public int encodeSurrogate(char c, char c2) {
        int n = Character.toCodePoint(c, c2);
        if (n < 131072 || n >= 196608) {
            return 65533;
        }
        int n2 = this.c2bSupp.length / 2;
        int n3 = Arrays.binarySearch(this.c2bSupp, 0, n2, (char)n);
        if (n3 >= 0) {
            return this.c2bSupp[n2 + n3];
        }
        return 65533;
    }

    public boolean isCompositeBase(Entry entry) {
        if (entry.cp <= 12791 && entry.cp >= 230) {
            return CharsetMapping.findCP(this.c2bComp, entry) >= 0;
        }
        return false;
    }

    public int encodeComposite(Entry entry) {
        int n = CharsetMapping.findComp(this.c2bComp, entry);
        if (n >= 0) {
            return this.c2bComp[n].bs;
        }
        return 65533;
    }

    public static CharsetMapping get(final Class clazz, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<CharsetMapping>(){

            @Override
            public CharsetMapping run() {
                return new CharsetMapping().load(clazz.getResourceAsStream(string));
            }
        });
    }

    static int findBytes(Entry[] entryArray, Entry entry) {
        return Arrays.binarySearch(entryArray, 0, entryArray.length, entry, comparatorBytes);
    }

    static int findCP(Entry[] entryArray, Entry entry) {
        return Arrays.binarySearch(entryArray, 0, entryArray.length, entry, comparatorCP);
    }

    static int findComp(Entry[] entryArray, Entry entry) {
        return Arrays.binarySearch(entryArray, 0, entryArray.length, entry, comparatorComp);
    }

    private static final void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    private static final void writeShortArray(OutputStream outputStream, int n, int[] nArray, int n2, int n3) throws IOException {
        CharsetMapping.writeShort(outputStream, n);
        CharsetMapping.writeShort(outputStream, n3);
        for (int i = n2; i < n3; ++i) {
            CharsetMapping.writeShort(outputStream, nArray[n2 + i]);
        }
    }

    public static final void writeSIZE(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public static void writeINDEXC2B(OutputStream outputStream, int[] nArray) throws IOException {
        CharsetMapping.writeShort(outputStream, 8);
        CharsetMapping.writeShort(outputStream, nArray.length);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) {
                CharsetMapping.writeShort(outputStream, n);
                n += 256;
                continue;
            }
            CharsetMapping.writeShort(outputStream, -1);
        }
    }

    public static void writeSINGLEBYTE(OutputStream outputStream, int[] nArray) throws IOException {
        CharsetMapping.writeShortArray(outputStream, 1, nArray, 0, 256);
    }

    private static void writeDOUBLEBYTE(OutputStream outputStream, int n, int[] nArray, int n2, int n3, int n4, int n5) throws IOException {
        CharsetMapping.writeShort(outputStream, n);
        CharsetMapping.writeShort(outputStream, n2);
        CharsetMapping.writeShort(outputStream, n3);
        CharsetMapping.writeShort(outputStream, n4);
        CharsetMapping.writeShort(outputStream, n5);
        CharsetMapping.writeShort(outputStream, (n3 - n2 + 1) * (n5 - n4 + 1));
        for (int i = n2; i <= n3; ++i) {
            for (int j = n4; j <= n5; ++j) {
                CharsetMapping.writeShort(outputStream, nArray[i * 256 + j]);
            }
        }
    }

    public static void writeDOUBLEBYTE1(OutputStream outputStream, int[] nArray, int n, int n2, int n3, int n4) throws IOException {
        CharsetMapping.writeDOUBLEBYTE(outputStream, 2, nArray, n, n2, n3, n4);
    }

    public static void writeDOUBLEBYTE2(OutputStream outputStream, int[] nArray, int n, int n2, int n3, int n4) throws IOException {
        CharsetMapping.writeDOUBLEBYTE(outputStream, 3, nArray, n, n2, n3, n4);
    }

    public static void writeSUPPLEMENT(OutputStream outputStream, Entry[] entryArray, int n) throws IOException {
        int n2;
        CharsetMapping.writeShort(outputStream, 5);
        CharsetMapping.writeShort(outputStream, n * 2);
        for (n2 = 0; n2 < n; ++n2) {
            CharsetMapping.writeShort(outputStream, entryArray[n2].bs);
        }
        for (n2 = 0; n2 < n; ++n2) {
            CharsetMapping.writeShort(outputStream, entryArray[n2].cp);
        }
        CharsetMapping.writeShort(outputStream, 6);
        CharsetMapping.writeShort(outputStream, n * 2);
        Arrays.sort(entryArray, 0, n, comparatorCP);
        for (n2 = 0; n2 < n; ++n2) {
            CharsetMapping.writeShort(outputStream, entryArray[n2].cp);
        }
        for (n2 = 0; n2 < n; ++n2) {
            CharsetMapping.writeShort(outputStream, entryArray[n2].bs);
        }
    }

    public static void writeCOMPOSITE(OutputStream outputStream, Entry[] entryArray, int n) throws IOException {
        CharsetMapping.writeShort(outputStream, 7);
        CharsetMapping.writeShort(outputStream, n * 3);
        for (int i = 0; i < n; ++i) {
            CharsetMapping.writeShort(outputStream, (char)entryArray[i].bs);
            CharsetMapping.writeShort(outputStream, (char)entryArray[i].cp);
            CharsetMapping.writeShort(outputStream, (char)entryArray[i].cp2);
        }
    }

    private static final boolean readNBytes(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3 = inputStream.read(byArray, n2, n);
            if (n3 == -1) {
                return false;
            }
            n -= n3;
            n2 += n3;
        }
        return true;
    }

    private char[] readCharArray() {
        int n = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)((this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF);
        }
        return cArray;
    }

    void readSINGLEBYTE() {
        char[] cArray = this.readCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\ufffd') continue;
            this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)] = (char)i;
        }
        this.b2cSB = cArray;
    }

    void readINDEXC2B() {
        char[] cArray = this.readCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (this.c2b != null || cArray[i] == '\uffffffff') continue;
            this.c2b = new char[cArray[i] + 256];
            Arrays.fill(this.c2b, '\ufffd');
            break;
        }
        this.c2bIndex = cArray;
    }

    char[] readDB(int n, int n2, int n3) {
        char[] cArray = this.readCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\ufffd') continue;
            int n4 = i / n3;
            int n5 = i % n3;
            int n6 = (n4 + n) * 256 + (n5 + n2);
            this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)] = (char)n6;
        }
        return cArray;
    }

    void readDOUBLEBYTE1() {
        this.b1MinDB1 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b1MaxDB1 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Min = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Max = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.dbSegSize = this.b2Max - this.b2Min + 1;
        this.b2cDB1 = this.readDB(this.b1MinDB1, this.b2Min, this.dbSegSize);
    }

    void readDOUBLEBYTE2() {
        this.b1MinDB2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b1MaxDB2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Min = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Max = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.dbSegSize = this.b2Max - this.b2Min + 1;
        this.b2cDB2 = this.readDB(this.b1MinDB2, this.b2Min, this.dbSegSize);
    }

    void readCOMPOSITE() {
        char[] cArray = this.readCharArray();
        int n = cArray.length / 3;
        this.b2cComp = new Entry[n];
        this.c2bComp = new Entry[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Entry entry = new Entry();
            entry.bs = cArray[n2++];
            entry.cp = cArray[n2++];
            entry.cp2 = cArray[n2++];
            this.b2cComp[i] = entry;
            this.c2bComp[i] = entry;
        }
        Arrays.sort(this.c2bComp, 0, this.c2bComp.length, comparatorComp);
    }

    CharsetMapping load(InputStream inputStream) {
        try {
            int n = (inputStream.read() & 0xFF) << 24 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
            this.bb = new byte[n];
            this.off = 0;
            if (!CharsetMapping.readNBytes(inputStream, this.bb, n)) {
                throw new RuntimeException("Corrupted data file");
            }
            inputStream.close();
            block11: while (this.off < n) {
                int n2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
                switch (n2) {
                    case 8: {
                        this.readINDEXC2B();
                        continue block11;
                    }
                    case 1: {
                        this.readSINGLEBYTE();
                        continue block11;
                    }
                    case 2: {
                        this.readDOUBLEBYTE1();
                        continue block11;
                    }
                    case 3: {
                        this.readDOUBLEBYTE2();
                        continue block11;
                    }
                    case 5: {
                        this.b2cSupp = this.readCharArray();
                        continue block11;
                    }
                    case 6: {
                        this.c2bSupp = this.readCharArray();
                        continue block11;
                    }
                    case 7: {
                        this.readCOMPOSITE();
                        continue block11;
                    }
                }
                throw new RuntimeException("Corrupted data file");
            }
            this.bb = null;
            return this;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static class Entry {
        public int bs;
        public int cp;
        public int cp2;

        public Entry() {
        }

        public Entry(int n, int n2, int n3) {
            this.bs = n;
            this.cp = n2;
            this.cp2 = n3;
        }
    }

    public static class Parser {
        static final Pattern basic = Pattern.compile("(?:0x)?(\\p{XDigit}++)\\s++(?:0x)?(\\p{XDigit}++)?\\s*+.*");
        static final int gBS = 1;
        static final int gCP = 2;
        static final int gCP2 = 3;
        BufferedReader reader;
        boolean closed;
        Matcher matcher;
        int gbs;
        int gcp;
        int gcp2;

        public Parser(InputStream inputStream, Pattern pattern, int n, int n2, int n3) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.closed = false;
            this.matcher = pattern.matcher("");
            this.gbs = n;
            this.gcp = n2;
            this.gcp2 = n3;
        }

        public Parser(InputStream inputStream, Pattern pattern) throws IOException {
            this(inputStream, pattern, 1, 2, 3);
        }

        public Parser(InputStream inputStream) throws IOException {
            this(inputStream, basic, 1, 2, 3);
        }

        protected boolean isDirective(String string) {
            return string.startsWith("#");
        }

        protected Entry parse(Matcher matcher, Entry entry) {
            entry.bs = Integer.parseInt(matcher.group(this.gbs), 16);
            entry.cp = Integer.parseInt(matcher.group(this.gcp), 16);
            entry.cp2 = this.gcp2 <= matcher.groupCount() && matcher.group(this.gcp2) != null ? Integer.parseInt(matcher.group(this.gcp2), 16) : 0;
            return entry;
        }

        public Entry next() throws Exception {
            return this.next(new Entry());
        }

        public Entry next(Entry entry) throws Exception {
            String string;
            if (this.closed) {
                return null;
            }
            while ((string = this.reader.readLine()) != null) {
                if (this.isDirective(string)) continue;
                this.matcher.reset(string);
                if (!this.matcher.lookingAt()) continue;
                return this.parse(this.matcher, entry);
            }
            this.reader.close();
            this.closed = true;
            return null;
        }
    }
}

