/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.Confounder;
import sun.security.krb5.internal.crypto.KeyUsage;
import sun.security.krb5.internal.crypto.dk.DkCrypto;

public class AesDkCrypto
extends DkCrypto {
    private static final boolean debug = false;
    private static final int BLOCK_SIZE = 16;
    private static final int DEFAULT_ITERATION_COUNT = 4096;
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int hashSize = 12;
    private final int keyLength;

    public AesDkCrypto(int n) {
        this.keyLength = n;
    }

    protected int getKeySeedLength() {
        return this.keyLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] stringToKey(char[] cArray, String string, byte[] byArray) throws GeneralSecurityException {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
            byte[] byArray3 = this.stringToKey(cArray, byArray2, byArray);
            return byArray3;
        }
        catch (Exception exception) {
            byte[] byArray4 = null;
            return byArray4;
        }
        finally {
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
    }

    private byte[] stringToKey(char[] cArray, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = 4096;
        if (byArray2 != null) {
            if (byArray2.length != 4) {
                throw new RuntimeException("Invalid parameter to stringToKey");
            }
            n = AesDkCrypto.readBigEndian(byArray2, 0, 4);
        }
        byte[] byArray3 = this.randomToKey(AesDkCrypto.PBKDF2(cArray, byArray, n, this.getKeySeedLength()));
        byte[] byArray4 = this.dk(byArray3, KERBEROS_CONSTANT);
        return byArray4;
    }

    protected byte[] randomToKey(byte[] byArray) {
        return byArray;
    }

    protected Cipher getCipher(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        if (byArray2 == null) {
            byArray2 = ZERO_IV;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
        cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    public int getChecksumLength() {
        return 12;
    }

    protected byte[] getHmac(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKeySpec);
        byte[] byArray3 = mac.doFinal(byArray2);
        byte[] byArray4 = new byte[12];
        System.arraycopy(byArray3, 0, byArray4, 0, 12);
        return byArray4;
    }

    public byte[] calculateChecksum(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray3 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), -103};
        byte[] byArray4 = this.dk(byArray, byArray3);
        try {
            byte[] byArray5 = this.getHmac(byArray4, byArray2);
            if (byArray5.length == this.getChecksumLength()) {
                byte[] byArray6 = byArray5;
                return byArray6;
            }
            if (byArray5.length > this.getChecksumLength()) {
                byte[] byArray7 = new byte[this.getChecksumLength()];
                System.arraycopy(byArray5, 0, byArray7, 0, byArray7.length);
                byte[] byArray8 = byArray7;
                return byArray8;
            }
            throw new GeneralSecurityException("checksum size too short: " + byArray5.length + "; expecting : " + this.getChecksumLength());
        }
        finally {
            Arrays.fill(byArray4, 0, byArray4.length, (byte)0);
        }
    }

    public byte[] encrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray5 = this.encryptCTS(byArray, n, byArray2, byArray3, byArray4, n2, n3, true);
        return byArray5;
    }

    public byte[] encryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = this.encryptCTS(byArray, n, byArray2, null, byArray3, n2, n3, false);
        return byArray4;
    }

    public byte[] decrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = this.decryptCTS(byArray, n, byArray2, byArray3, n2, n3, true);
        return byArray4;
    }

    public byte[] decryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = this.decryptCTS(byArray, n, byArray2, byArray3, n2, n3, false);
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encryptCTS(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3, boolean bl) throws GeneralSecurityException, KrbCryptoException {
        byte[] byArray5;
        byte[] byArray6;
        block7: {
            byte[] byArray7 = null;
            byArray6 = null;
            try {
                byte[] byArray8;
                byte[] byArray9 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), -86};
                byArray7 = this.dk(byArray, byArray9);
                byte[] byArray10 = null;
                if (bl) {
                    byArray8 = Confounder.bytes(16);
                    byArray10 = new byte[byArray8.length + n3];
                    System.arraycopy(byArray8, 0, byArray10, 0, byArray8.length);
                    System.arraycopy(byArray4, n2, byArray10, byArray8.length, n3);
                } else {
                    byArray10 = new byte[n3];
                    System.arraycopy(byArray4, n2, byArray10, 0, n3);
                }
                byArray8 = new byte[byArray10.length + 12];
                Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray7, "AES");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                cipher.doFinal(byArray10, 0, byArray10.length, byArray8);
                byArray9[4] = 85;
                byArray6 = this.dk(byArray, byArray9);
                byte[] byArray11 = this.getHmac(byArray6, byArray10);
                System.arraycopy(byArray11, 0, byArray8, byArray10.length, byArray11.length);
                byArray5 = byArray8;
                if (byArray7 == null) break block7;
            }
            catch (Throwable throwable) {
                if (byArray7 != null) {
                    Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                }
                if (byArray6 != null) {
                    Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
        }
        if (byArray6 != null) {
            Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
        }
        return byArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decryptCTS(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3, boolean bl) throws GeneralSecurityException {
        byte[] byArray4;
        byte[] byArray5;
        block12: {
            byte[] byArray6;
            byte[] byArray7;
            block10: {
                byte[] byArray8;
                block11: {
                    byArray7 = null;
                    byArray5 = null;
                    try {
                        byte[] byArray9 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), -86};
                        byArray7 = this.dk(byArray, byArray9);
                        Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray7, "AES");
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
                        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                        byArray6 = cipher.doFinal(byArray3, n2, n3 - 12);
                        byArray9[4] = 85;
                        byArray5 = this.dk(byArray, byArray9);
                        byte[] byArray10 = this.getHmac(byArray5, byArray6);
                        int n4 = n2 + n3 - 12;
                        boolean bl2 = false;
                        if (byArray10.length >= 12) {
                            for (int i = 0; i < 12; ++i) {
                                if (byArray10[i] == byArray3[n4 + i]) continue;
                                bl2 = true;
                                System.err.println("Checksum failed !");
                                break;
                            }
                        }
                        if (bl2) {
                            throw new GeneralSecurityException("Checksum failed");
                        }
                        if (!bl) break block10;
                        byte[] byArray11 = new byte[byArray6.length - 16];
                        System.arraycopy(byArray6, 16, byArray11, 0, byArray11.length);
                        byArray8 = byArray11;
                        if (byArray7 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (byArray7 != null) {
                            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                        }
                        if (byArray5 != null) {
                            Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
                        }
                        throw throwable;
                    }
                    Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                }
                if (byArray5 != null) {
                    Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
                }
                return byArray8;
            }
            byArray4 = byArray6;
            if (byArray7 == null) break block12;
            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
        }
        if (byArray5 != null) {
            Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
        }
        return byArray4;
    }

    private static byte[] PBKDF2(char[] cArray, byte[] byArray, int n, int n2) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n, n2);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        byte[] byArray2 = secretKey.getEncoded();
        return byArray2;
    }

    public static final int readBigEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = (n2 - 1) * 8;
        while (n2 > 0) {
            n3 += (byArray[n] & 0xFF) << n4;
            n4 -= 8;
            ++n;
            --n2;
        }
        return n3;
    }
}

