/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.awt.GlobalCursorManager;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

public final class XGlobalCursorManager
extends GlobalCursorManager {
    private static Field field_pData;
    private static Field field_type;
    private static Class cursorClass;
    private static Method method_setPData;
    private Component nativeContainer;
    private static XGlobalCursorManager manager;

    static GlobalCursorManager getCursorManager() {
        if (manager == null) {
            manager = new XGlobalCursorManager();
        }
        return manager;
    }

    static void nativeUpdateCursor(Component component) {
        XGlobalCursorManager.getCursorManager().updateCursorLater(component);
    }

    protected void setCursor(Component component, Cursor cursor, boolean bl) {
        Component component2;
        Cursor cursor2;
        if (component == null) {
            return;
        }
        CapableCursorAndComponent capableCursorAndComponent = null;
        if (bl) {
            cursor2 = cursor;
        } else {
            capableCursorAndComponent = CapableCursorAndComponent.getNew(component);
            cursor2 = capableCursorAndComponent.cursor;
        }
        Cursor cursor3 = cursor2;
        Component component3 = capableCursorAndComponent != null ? capableCursorAndComponent.component : null;
        Component component4 = component2 = bl ? this.nativeContainer : this.getNativeContainer(component);
        if (component2 != null && component2.isDisplayable() && component2.getPeer() instanceof XComponentPeer) {
            this.nativeContainer = component2;
            ((XComponentPeer)component2.getPeer()).pSetCursor(cursor3, component3);
            XGlobalCursorManager.updateGrabbedCursor(cursor3);
        }
    }

    private static void updateGrabbedCursor(Cursor cursor) {
        XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
        if (xBaseWindow instanceof XWindowPeer) {
            XWindowPeer xWindowPeer = (XWindowPeer)xBaseWindow;
            xWindowPeer.pSetCursor(cursor);
        }
    }

    protected void updateCursorOutOfJava() {
        XGlobalCursorManager.updateGrabbedCursor(Cursor.getPredefinedCursor(0));
    }

    private Component getNativeContainer(Component component) {
        while (component != null && component.isLightweight()) {
            component = component.getParent();
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCursorPos(Point point) {
        if (!((XToolkit)Toolkit.getDefaultToolkit()).getLastCursorPos(point)) {
            XToolkit.awtLock();
            try {
                long l = XToolkit.getDisplay();
                long l2 = XlibWrapper.RootWindow(l, XlibWrapper.DefaultScreen(l));
                XlibWrapper.XQueryPointer(l, l2, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                point.x = XlibWrapper.unsafe.getInt(XlibWrapper.larg3);
                point.y = XlibWrapper.unsafe.getInt(XlibWrapper.larg4);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    protected Component findHeavyweightUnderCursor() {
        return XAwtState.getComponentMouseEntered();
    }

    protected Component findComponentAt(Container container, int n, int n2) {
        return container.findComponentAt(n, n2);
    }

    protected Point getLocationOnScreen(Component component) {
        return component.getLocationOnScreen();
    }

    protected Component findHeavyweightUnderCursor(boolean bl) {
        return this.findHeavyweightUnderCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCursor(Cursor cursor) {
        long l = 0L;
        int n = 0;
        try {
            l = field_pData.getLong(cursor);
            n = field_type.getInt(cursor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (l != 0L) {
            return l;
        }
        long l2 = 0L;
        switch (n) {
            case 0: {
                l2 = 68L;
                break;
            }
            case 1: {
                l2 = 34L;
                break;
            }
            case 2: {
                l2 = 152L;
                break;
            }
            case 3: {
                l2 = 150L;
                break;
            }
            case 4: {
                l2 = 12L;
                break;
            }
            case 6: {
                l2 = 134L;
                break;
            }
            case 5: {
                l2 = 14L;
                break;
            }
            case 7: {
                l2 = 136L;
                break;
            }
            case 9: {
                l2 = 16L;
                break;
            }
            case 8: {
                l2 = 138L;
                break;
            }
            case 10: {
                l2 = 70L;
                break;
            }
            case 11: {
                l2 = 96L;
                break;
            }
            case 12: {
                l2 = 60L;
                break;
            }
            case 13: {
                l2 = 52L;
            }
        }
        XToolkit.awtLock();
        try {
            l = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), (int)l2);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XGlobalCursorManager.setPData(cursor, l);
        return l;
    }

    static void setPData(Cursor cursor, long l) {
        try {
            method_setPData.invoke(cursor, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        cursorClass = Cursor.class;
        field_pData = XToolkit.getField(cursorClass, "pData");
        field_type = XToolkit.getField(cursorClass, "type");
        method_setPData = XToolkit.getMethod(cursorClass, "setPData", new Class[]{Long.TYPE});
        if (field_pData == null || field_type == null || method_setPData == null) {
            System.out.println("Unable to initialize XGlobalCursorManager: ");
            Thread.dumpStack();
        }
    }

    private static final class CapableCursorAndComponent {
        final Cursor cursor;
        final Component component;

        private CapableCursorAndComponent(Cursor cursor, Component component) {
            this.cursor = cursor;
            this.component = component;
        }

        static CapableCursorAndComponent getNew(Component component) {
            Component component2;
            for (component2 = component; component2 != null && !(component2 instanceof Window) && component2.isEnabled() && component2.isVisible() && component2.isDisplayable(); component2 = component2.getParent()) {
            }
            if (component2 instanceof Window) {
                if (component2.isEnabled() && component2.isVisible() && component2.isDisplayable() && component.isEnabled()) {
                    return new CapableCursorAndComponent(component.getCursor(), component);
                }
                return new CapableCursorAndComponent(Cursor.getPredefinedCursor(0), null);
            }
            if (component2 == null) {
                return new CapableCursorAndComponent(null, null);
            }
            return CapableCursorAndComponent.getNew(component2.getParent());
        }
    }
}

