/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsLongBufferRL;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

class ByteBufferAsLongBufferL
extends LongBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsLongBufferL(ByteBuffer byteBuffer) {
        super(-1, 0, byteBuffer.remaining() >> 3, byteBuffer.remaining() >> 3);
        this.bb = byteBuffer;
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.offset = n2;
    }

    ByteBufferAsLongBufferL(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.bb = byteBuffer;
        this.offset = n5;
    }

    public LongBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = (n << 3) + this.offset;
        assert (n4 >= 0);
        return new ByteBufferAsLongBufferL(this.bb, -1, 0, n3, n3, n4);
    }

    public LongBuffer duplicate() {
        return new ByteBufferAsLongBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public LongBuffer asReadOnlyBuffer() {
        return new ByteBufferAsLongBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return (n << 3) + this.offset;
    }

    public long get() {
        return Bits.getLongL(this.bb, this.ix(this.nextGetIndex()));
    }

    public long get(int n) {
        return Bits.getLongL(this.bb, this.ix(this.checkIndex(n)));
    }

    public LongBuffer put(long l) {
        Bits.putLongL(this.bb, this.ix(this.nextPutIndex()), l);
        return this;
    }

    public LongBuffer put(int n, long l) {
        Bits.putLongL(this.bb, this.ix(this.checkIndex(n)), l);
        return this;
    }

    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.limit(this.ix(n2));
        byteBuffer.position(this.ix(0));
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.position(n << 3);
        byteBuffer2.compact();
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

