/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _NUMPREVW_HXX
#define _NUMPREVW_HXX


#include <vcl/window.hxx>

class SwNumRule;
/*-----------------02.12.97 10:31-------------------

--------------------------------------------------*/

class NumberingPreview : public Window
{
	const SwNumRule* 	pActNum;
	Font 				aStdFont;
	long				nPageWidth;
	const String* 		pOutlineNames;
	BOOL				bPosition;
	UINT16 				nActLevel;

	protected:
		virtual void		Paint( const Rectangle& rRect );

	public:
		NumberingPreview(Window* pParent, const ResId& rResId ) :
			Window(pParent, rResId),
			pActNum(0),nPageWidth(0), pOutlineNames(0), bPosition(FALSE), nActLevel(USHRT_MAX) {}
		~NumberingPreview();

		void	SetNumRule(const SwNumRule* pNum)
					{pActNum = pNum; Invalidate();};
		void	SetPageWidth(long nPgWidth)
								{nPageWidth = nPgWidth;}
		void	SetOutlineNames(const String* pNames)
						{pOutlineNames = pNames;}
		void	SetPositionMode()
						{ bPosition = TRUE;}
		void	SetLevel(USHORT nSet) {nActLevel = nSet;}

};

#endif


