/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class VetoableChangeSupport
implements Serializable {
    private transient Vector listeners;
    private Hashtable children;
    private Object source;
    private int vetoableChangeSupportSerializedDataVersion = 2;
    static final long serialVersionUID = -5090210921595982017L;

    public VetoableChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            return;
        }
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.addVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            return;
        }
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.removeVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.removeElement(vetoableChangeListener);
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        ArrayList<VetoableChangeListenerProxy> arrayList = new ArrayList<VetoableChangeListenerProxy>();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        if (this.children != null) {
            for (String string : this.children.keySet()) {
                VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
                VetoableChangeListener[] vetoableChangeListenerArray = vetoableChangeSupport.getVetoableChangeListeners();
                for (int i = vetoableChangeListenerArray.length - 1; i >= 0; --i) {
                    arrayList.add(new VetoableChangeListenerProxy(string, vetoableChangeListenerArray[i]));
                }
            }
        }
        return arrayList.toArray(new VetoableChangeListener[0]);
    }

    public synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        VetoableChangeSupport vetoableChangeSupport;
        if (vetoableChangeListener == null || string == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string)) == null) {
            vetoableChangeSupport = new VetoableChangeSupport(this.source);
            this.children.put(string, vetoableChangeSupport);
        }
        vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null || string == null) {
            return;
        }
        if (this.children == null) {
            return;
        }
        VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
        if (vetoableChangeSupport == null) {
            return;
        }
        vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String string) {
        VetoableChangeSupport vetoableChangeSupport;
        ArrayList<VetoableChangeListener> arrayList = new ArrayList<VetoableChangeListener>();
        if (this.children != null && string != null && (vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string)) != null) {
            arrayList.addAll(Arrays.asList(vetoableChangeSupport.getVetoableChangeListeners()));
        }
        return arrayList.toArray(new VetoableChangeListener[0]);
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.listeners == null && this.children == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, string, object, object2);
        this.fireVetoableChange(propertyChangeEvent);
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        if (n == n2) {
            return;
        }
        this.fireVetoableChange(string, new Integer(n), new Integer(n2));
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        if (bl == bl2) {
            return;
        }
        this.fireVetoableChange(string, (Object)bl, (Object)bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        Vector vector = null;
        VetoableChangeSupport vetoableChangeSupport = null;
        VetoableChangeSupport vetoableChangeSupport2 = this;
        synchronized (vetoableChangeSupport2) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
            }
        }
        if (this.listeners != null) {
            try {
                for (int i = 0; i < vector.size(); ++i) {
                    VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)vector.elementAt(i);
                    vetoableChangeListener.vetoableChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyChangeEvent = new PropertyChangeEvent(this.source, string, object2, object);
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)vector.elementAt(i);
                        vetoableChangeListener.vetoableChange(propertyChangeEvent);
                        continue;
                    }
                    catch (PropertyVetoException propertyVetoException2) {
                        // empty catch block
                    }
                }
                throw propertyVetoException;
            }
        }
        if (vetoableChangeSupport != null) {
            vetoableChangeSupport.fireVetoableChange(propertyChangeEvent);
        }
    }

    public synchronized boolean hasListeners(String string) {
        VetoableChangeSupport vetoableChangeSupport;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && string != null && (vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string)) != null && vetoableChangeSupport.listeners != null) {
            return !vetoableChangeSupport.listeners.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = null;
        VetoableChangeSupport vetoableChangeSupport = this;
        synchronized (vetoableChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)vector.elementAt(i);
                if (!(vetoableChangeListener instanceof Serializable)) continue;
                objectOutputStream.writeObject(vetoableChangeListener);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addVetoableChangeListener((VetoableChangeListener)object);
        }
    }
}

