/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.AttrFilter;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;

public final class LazySearchEnumerationImpl
implements NamingEnumeration {
    private NamingEnumeration candidates;
    private SearchResult nextMatch = null;
    private SearchControls cons;
    private AttrFilter filter;
    private Context context;
    private Hashtable env;
    private boolean useFactory = true;

    public LazySearchEnumerationImpl(NamingEnumeration namingEnumeration, AttrFilter attrFilter, SearchControls searchControls) throws NamingException {
        this.candidates = namingEnumeration;
        this.filter = attrFilter;
        this.cons = searchControls == null ? new SearchControls() : searchControls;
    }

    public LazySearchEnumerationImpl(NamingEnumeration namingEnumeration, AttrFilter attrFilter, SearchControls searchControls, Context context, Hashtable hashtable, boolean bl) throws NamingException {
        this.candidates = namingEnumeration;
        this.filter = attrFilter;
        this.env = hashtable;
        this.context = context;
        this.useFactory = bl;
        this.cons = searchControls == null ? new SearchControls() : searchControls;
    }

    public LazySearchEnumerationImpl(NamingEnumeration namingEnumeration, AttrFilter attrFilter, SearchControls searchControls, Context context, Hashtable hashtable) throws NamingException {
        this(namingEnumeration, attrFilter, searchControls, context, hashtable, true);
    }

    public boolean hasMore() throws NamingException {
        return this.findNextMatch(false) != null;
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public Object nextElement() {
        try {
            return this.findNextMatch(true);
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.toString());
        }
    }

    public Object next() throws NamingException {
        return this.findNextMatch(true);
    }

    public void close() throws NamingException {
        if (this.candidates != null) {
            this.candidates.close();
        }
    }

    private SearchResult findNextMatch(boolean bl) throws NamingException {
        if (this.nextMatch != null) {
            SearchResult searchResult = this.nextMatch;
            if (bl) {
                this.nextMatch = null;
            }
            return searchResult;
        }
        while (this.candidates.hasMore()) {
            Attributes attributes;
            Binding binding = (Binding)this.candidates.next();
            Object object = binding.getObject();
            if (!(object instanceof DirContext) || !this.filter.check(attributes = ((DirContext)object).getAttributes(""))) continue;
            if (!this.cons.getReturningObjFlag()) {
                object = null;
            } else if (this.useFactory) {
                try {
                    CompositeName compositeName = this.context != null ? new CompositeName(binding.getName()) : null;
                    object = DirectoryManager.getObjectInstance(object, compositeName, this.context, this.env, attributes);
                }
                catch (NamingException namingException) {
                    throw namingException;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("problem generating object using object factory");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            SearchResult searchResult = new SearchResult(binding.getName(), binding.getClassName(), object, SearchFilter.selectAttributes(attributes, this.cons.getReturningAttributes()), true);
            if (!bl) {
                this.nextMatch = searchResult;
            }
            return searchResult;
        }
        return null;
    }
}

