/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XVerticalScrollbar;
import sun.awt.X11.XWindow;

public class ListHelper
implements XScrollbarClient {
    private static final Logger log = Logger.getLogger("sun.awt.X11.ListHelper");
    private final int FOCUS_INSET = 1;
    private final int BORDER_WIDTH;
    private final int ITEM_MARGIN;
    private final int TEXT_SPACE;
    private final int SCROLLBAR_WIDTH;
    private List items;
    private List selected;
    private boolean multiSelect;
    private int focusedIndex;
    private int maxVisItems;
    private XVerticalScrollbar vsb;
    private boolean vsbVis;
    private XHorizontalScrollbar hsb;
    private boolean hsbVis;
    private Font font;
    private FontMetrics fm;
    private XWindow peer;
    private Color[] colors;
    boolean mouseDraggedOutVertically = false;
    private volatile boolean vsbVisibilityChanged = false;

    public ListHelper(XWindow xWindow, Color[] colorArray, int n, boolean bl, boolean bl2, boolean bl3, Font font, int n2, int n3, int n4, int n5, int n6) {
        this.peer = xWindow;
        this.colors = colorArray;
        this.multiSelect = bl;
        this.items = new ArrayList(n);
        this.selected = new ArrayList(1);
        this.selected.add(-1);
        this.maxVisItems = n2;
        if (bl2) {
            this.vsb = new XVerticalScrollbar(this);
            this.vsb.setValues(0, 0, 0, 0, 1, n2 - 1);
        }
        if (bl3) {
            this.hsb = new XHorizontalScrollbar(this);
            this.hsb.setValues(0, 0, 0, 0, 1, 1);
        }
        this.setFont(font);
        this.TEXT_SPACE = n3;
        this.ITEM_MARGIN = n4;
        this.BORDER_WIDTH = n5;
        this.SCROLLBAR_WIDTH = n6;
    }

    public Component getEventSource() {
        return this.peer.getEventSource();
    }

    public void add(String string) {
        this.items.add(string);
        this.updateScrollbars();
    }

    public void add(String string, int n) {
        this.items.add(n, string);
        this.updateScrollbars();
    }

    public void remove(String string) {
        this.items.remove(string);
        this.updateScrollbars();
    }

    public void remove(int n) {
        this.items.remove(n);
        this.updateScrollbars();
    }

    public void removeAll() {
        this.items.removeAll(this.items);
        this.updateScrollbars();
    }

    public void setMultiSelect(boolean bl) {
        this.multiSelect = bl;
    }

    public void select(int n) {
        if (n > this.getItemCount() - 1) {
            int n2 = n = this.isEmpty() ? -1 : 0;
        }
        if (this.multiSelect) {
            assert (false) : "Implement ListHelper.select() for multiselect";
        } else if (this.getSelectedIndex() != n) {
            this.selected.remove(0);
            this.selected.add(n);
            this.makeVisible(n);
        }
    }

    public void deselect(int n) {
        assert (false);
    }

    public int getSelectedIndex() {
        if (!this.multiSelect) {
            Integer n = (Integer)this.selected.get(0);
            return n;
        }
        return -1;
    }

    int[] getSelectedIndexes() {
        assert (false);
        return null;
    }

    public boolean checkVsbVisibilityChangedAndReset() {
        boolean bl = this.vsbVisibilityChanged;
        this.vsbVisibilityChanged = false;
        return bl;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItem(int n) {
        return (String)this.items.get(n);
    }

    public void setFocusedIndex(int n) {
        this.focusedIndex = n;
    }

    public boolean isFocusedIndex(int n) {
        return n == this.focusedIndex;
    }

    public void setFont(Font font) {
        if (font != this.font) {
            this.font = font;
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        }
    }

    public int getMaxItemWidth() {
        int n = 0;
        int n2 = this.getItemCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.fm.stringWidth(this.getItem(i));
            n = Math.max(n, n3);
        }
        return n;
    }

    int getItemHeight() {
        return this.fm.getHeight() + 2 * this.TEXT_SPACE;
    }

    public int y2index(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("y=" + n + ", firstIdx=" + this.firstDisplayedIndex() + ", itemHeight=" + this.getItemHeight() + ",item_margin=" + this.ITEM_MARGIN);
        }
        int n2 = this.firstDisplayedIndex() + (n - 2 * this.ITEM_MARGIN) / (this.getItemHeight() + 2 * this.ITEM_MARGIN);
        return n2;
    }

    public int firstDisplayedIndex() {
        if (this.vsbVis) {
            return this.vsb.getValue();
        }
        return 0;
    }

    public int lastDisplayedIndex() {
        if (this.hsbVis) assert (false) : "Implement for horiz scroll bar";
        return this.vsbVis ? this.vsb.getValue() + this.maxVisItems - 1 : this.getItemCount() - 1;
    }

    public void makeVisible(int n) {
        if (this.vsbVis) {
            if (n < this.firstDisplayedIndex()) {
                this.vsb.setValue(n);
            } else if (n > this.lastDisplayedIndex()) {
                this.vsb.setValue(n - this.maxVisItems + 1);
            }
        }
    }

    public void up() {
        int n = this.getSelectedIndex();
        int n2 = this.getItemCount();
        assert (n >= 0);
        int n3 = n == 0 ? n2 - 1 : --n;
        this.select(n3);
    }

    public void down() {
        int n = (this.getSelectedIndex() + 1) % this.getItemCount();
        this.select(n);
    }

    public void pageUp() {
        if (this.vsbVis && this.firstDisplayedIndex() > 0) {
            if (this.multiSelect) {
                assert (false) : "Implement pageUp() for multiSelect";
            } else {
                int n = this.getSelectedIndex() - this.firstDisplayedIndex();
                int n2 = this.firstDisplayedIndex() - this.vsb.getBlockIncrement();
                this.vsb.setValue(n2);
                this.select(this.firstDisplayedIndex() + n);
            }
        }
    }

    public void pageDown() {
        if (this.vsbVis && this.lastDisplayedIndex() < this.getItemCount() - 1) {
            if (this.multiSelect) {
                assert (false) : "Implement pageDown() for multiSelect";
            } else {
                int n = this.getSelectedIndex() - this.firstDisplayedIndex();
                int n2 = this.lastDisplayedIndex();
                this.vsb.setValue(n2);
                this.select(this.firstDisplayedIndex() + n);
            }
        }
    }

    public void home() {
    }

    public void end() {
    }

    public boolean isVSBVisible() {
        return this.vsbVis;
    }

    public boolean isHSBVisible() {
        return this.hsbVis;
    }

    public XVerticalScrollbar getVSB() {
        return this.vsb;
    }

    public XHorizontalScrollbar getHSB() {
        return this.hsb;
    }

    public boolean isInVertSB(Rectangle rectangle, int n, int n2) {
        if (this.vsbVis) {
            assert (this.vsb != null) : "Vert scrollbar is visible, yet is null?";
            int n3 = this.hsbVis ? rectangle.height - this.SCROLLBAR_WIDTH : rectangle.height;
            return n <= rectangle.width && n >= rectangle.width - this.SCROLLBAR_WIDTH && n2 >= 0 && n2 <= n3;
        }
        return false;
    }

    public boolean isInHorizSB(Rectangle rectangle, int n, int n2) {
        if (this.hsbVis) {
            assert (this.hsb != null) : "Horiz scrollbar is visible, yet is null?";
            int n3 = this.vsbVis ? rectangle.width - this.SCROLLBAR_WIDTH : rectangle.width;
            return n <= n3 && n >= 0 && n2 >= rectangle.height - this.SCROLLBAR_WIDTH && n2 <= rectangle.height;
        }
        return false;
    }

    public void handleVSBEvent(MouseEvent mouseEvent, Rectangle rectangle, int n, int n2) {
        int n3 = this.hsbVis ? rectangle.height - this.SCROLLBAR_WIDTH : rectangle.height;
        this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), n - (rectangle.width - this.SCROLLBAR_WIDTH), n2);
    }

    void updateScrollbars() {
        boolean bl = this.vsbVis;
        boolean bl2 = this.vsbVis = this.vsb != null && this.items.size() > this.maxVisItems;
        if (this.vsbVis) {
            this.vsb.setValues(this.vsb.getValue(), this.getNumItemsDisplayed(), this.vsb.getMinimum(), this.items.size());
        }
        this.vsbVisibilityChanged = this.vsbVis != bl;
    }

    public int getNumItemsDisplayed() {
        return this.items.size() > this.maxVisItems ? this.maxVisItems : this.items.size();
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        Graphics graphics = this.peer.getGraphics();
        Rectangle rectangle = this.peer.getBounds();
        if (xScrollbar == this.vsb && this.vsbVis) {
            this.paintVSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        } else if (xScrollbar == this.hsb && this.hsbVis) {
            this.paintHSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        }
        graphics.dispose();
    }

    public void notifyValue(XScrollbar xScrollbar, int n, int n2, boolean bl) {
        if (xScrollbar == this.vsb) {
            boolean bl2;
            int n3 = this.vsb.getValue();
            this.vsb.setValue(n2);
            boolean bl3 = bl2 = n3 != this.vsb.getValue();
            if (this.mouseDraggedOutVertically) {
                int n4 = this.getSelectedIndex();
                int n5 = this.getSelectedIndex() + n2 - n3;
                this.select(n5);
                bl2 = bl2 || this.getSelectedIndex() != n4;
            }
            Graphics graphics = this.peer.getGraphics();
            Rectangle rectangle = this.peer.getBounds();
            int n6 = n2;
            int n7 = Math.min(this.getItemCount() - 1, n2 + this.maxVisItems);
            if (bl2) {
                this.paintItems(graphics, this.colors, rectangle, n6, n7);
            }
            graphics.dispose();
        } else if ((XHorizontalScrollbar)xScrollbar == this.hsb) {
            this.hsb.setValue(n2);
        }
    }

    public void updateColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void paintItems(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
    }

    public void paintAllItems(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
        this.paintItems(graphics, colorArray, rectangle, this.firstDisplayedIndex(), this.lastDisplayedIndex());
    }

    public void paintItems(Graphics graphics, Color[] colorArray, Rectangle rectangle, int n, int n2) {
        this.peer.flush();
        int n3 = this.BORDER_WIDTH + this.ITEM_MARGIN;
        int n4 = rectangle.width - 2 * this.ITEM_MARGIN - 2 * this.BORDER_WIDTH - (this.vsbVis ? this.SCROLLBAR_WIDTH : 0);
        int n5 = this.getItemHeight();
        int n6 = this.BORDER_WIDTH + this.ITEM_MARGIN;
        for (int i = n; i <= n2; ++i) {
            this.paintItem(graphics, colorArray, this.getItem(i), n3, n6, n4, n5, this.isItemSelected(i), this.isFocusedIndex(i));
            n6 += n5 + 2 * this.ITEM_MARGIN;
        }
        if (this.vsbVis) {
            this.paintVSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        }
        if (this.hsbVis) {
            this.paintHSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        }
        this.peer.flush();
    }

    public void paintItem(Graphics graphics, Color[] colorArray, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (bl) {
            graphics.setColor(colorArray[3]);
        } else {
            graphics.setColor(colorArray[0]);
        }
        graphics.fillRect(n, n2, n3, n4);
        if (bl2) {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        }
        if (bl) {
            graphics.setColor(colorArray[0]);
        } else {
            graphics.setColor(colorArray[3]);
        }
        graphics.setFont(this.font);
        int n5 = this.fm.getAscent();
        int n6 = this.fm.getDescent();
        graphics.drawString(string, n + this.TEXT_SPACE, n2 + (n4 + this.fm.getMaxAscent() - this.fm.getMaxDescent()) / 2);
    }

    boolean isItemSelected(int n) {
        for (Integer n2 : this.selected) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintVSB(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
        int n = rectangle.height - 2 * this.BORDER_WIDTH - (this.hsbVis ? this.SCROLLBAR_WIDTH - 2 : 0);
        Graphics graphics2 = graphics.create();
        graphics.setColor(colorArray[0]);
        try {
            graphics2.translate(rectangle.width - this.BORDER_WIDTH - this.SCROLLBAR_WIDTH, this.BORDER_WIDTH);
            this.vsb.setSize(this.SCROLLBAR_WIDTH, rectangle.height);
            this.vsb.paint(graphics2, colorArray, true);
        }
        finally {
            graphics2.dispose();
        }
    }

    public void paintHSB(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
    }

    static boolean doWheelScroll(XVerticalScrollbar xVerticalScrollbar, XHorizontalScrollbar xHorizontalScrollbar, MouseWheelEvent mouseWheelEvent) {
        XScrollbar xScrollbar = null;
        if (xVerticalScrollbar != null) {
            xScrollbar = xVerticalScrollbar;
        } else if (xHorizontalScrollbar != null) {
            xScrollbar = xHorizontalScrollbar;
        } else {
            return false;
        }
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0 && xScrollbar.getValue() > xScrollbar.getMinimum() || n > 0 && xScrollbar.getValue() < xScrollbar.getMaximum() || n != 0) {
            int n2 = mouseWheelEvent.getScrollType();
            int n3 = n2 == 1 ? n * xScrollbar.getBlockIncrement() : mouseWheelEvent.getUnitsToScroll() * xScrollbar.getUnitIncrement();
            xScrollbar.setValue(xScrollbar.getValue() + n3);
            return true;
        }
        return false;
    }

    void trackMouseDraggedScroll(int n, int n2, int n3, int n4) {
        if (!this.mouseDraggedOutVertically) {
            if (this.vsb.beforeThumb(n, n2)) {
                this.vsb.setMode(2);
            } else {
                this.vsb.setMode(1);
            }
        }
        if (!(this.mouseDraggedOutVertically || n2 >= 0 && n2 < n4)) {
            this.mouseDraggedOutVertically = true;
            this.vsb.startScrollingInstance();
        }
        if (this.mouseDraggedOutVertically && n2 >= 0 && n2 < n4 && n >= 0 && n < n3) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
    }

    void trackMouseReleasedScroll() {
        if (this.mouseDraggedOutVertically) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
    }
}

