/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public final class NamespaceContextImplementation
implements NamespaceContext {
    private static int DEFAULT_SIZE = 8;
    private String[] prefixes = new String[DEFAULT_SIZE];
    private String[] namespaceURIs = new String[DEFAULT_SIZE];
    private int namespacePosition;
    private int[] contexts = new int[DEFAULT_SIZE];
    private int contextPosition;
    private int currentContext;

    public NamespaceContextImplementation() {
        this.prefixes[0] = "xml";
        this.namespaceURIs[0] = "http://www.w3.org/XML/1998/namespace";
        this.prefixes[1] = "xmlns";
        this.namespaceURIs[1] = "http://www.w3.org/2000/xmlns/";
        this.namespacePosition = 2;
        this.currentContext = 2;
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.intern();
        for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.prefixes[i];
            if (string2 != string) continue;
            return this.namespaceURIs[i];
        }
        return "";
    }

    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.namespaceURIs[i];
            if (string2 != string && !string2.equals(string)) continue;
            String string3 = this.prefixes[i];
            boolean bl = false;
            for (int j = i + 1; j < this.namespacePosition; ++j) {
                if (string3 != this.prefixes[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return string3;
        }
        return null;
    }

    public String getNonDefaultPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.namespaceURIs[i];
            if (string2 != string && !string2.equals(string) || this.prefixes[i].length() <= 0) continue;
            String string3 = this.prefixes[i];
            ++i;
            while (i < this.namespacePosition) {
                if (string3 == this.prefixes[i]) {
                    return null;
                }
                ++i;
            }
            return string3;
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.namespaceURIs[i];
            if (string2 != string && !string2.equals(string)) continue;
            String string3 = this.prefixes[i];
            for (int j = i + 1; j < this.namespacePosition; ++j) {
                if (string3 == this.prefixes[j]) continue block0;
            }
            arrayList.add(string3);
        }
        return arrayList.iterator();
    }

    public String getPrefix(int n) {
        return this.prefixes[n];
    }

    public String getNamespaceURI(int n) {
        return this.namespaceURIs[n];
    }

    public int getCurrentContextStartIndex() {
        return this.currentContext;
    }

    public int getCurrentContextEndIndex() {
        return this.namespacePosition;
    }

    public boolean isCurrentContextEmpty() {
        return this.currentContext == this.namespacePosition;
    }

    public void declarePrefix(String string, String string2) {
        string = string.intern();
        string2 = string2.intern();
        if (string == "xml" || string == "xmlns") {
            return;
        }
        for (int i = this.currentContext; i < this.namespacePosition; ++i) {
            String string3 = this.prefixes[i];
            if (string3 != string) continue;
            this.prefixes[i] = string;
            this.namespaceURIs[i] = string2;
            return;
        }
        if (this.namespacePosition == this.namespaceURIs.length) {
            this.resizeNamespaces();
        }
        this.prefixes[this.namespacePosition] = string;
        this.namespaceURIs[this.namespacePosition++] = string2;
    }

    private void resizeNamespaces() {
        int n = this.namespaceURIs.length * 3 / 2 + 1;
        String[] stringArray = new String[n];
        System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixes.length);
        this.prefixes = stringArray;
        String[] stringArray2 = new String[n];
        System.arraycopy(this.namespaceURIs, 0, stringArray2, 0, this.namespaceURIs.length);
        this.namespaceURIs = stringArray2;
    }

    public void pushContext() {
        if (this.contextPosition == this.contexts.length) {
            this.resizeContexts();
        }
        this.contexts[this.contextPosition++] = this.currentContext = this.namespacePosition;
    }

    private void resizeContexts() {
        int[] nArray = new int[this.contexts.length * 3 / 2 + 1];
        System.arraycopy(this.contexts, 0, nArray, 0, this.contexts.length);
        this.contexts = nArray;
    }

    public void popContext() {
        if (this.contextPosition > 0) {
            this.namespacePosition = this.currentContext = this.contexts[--this.contextPosition];
        }
    }

    public void reset() {
        this.namespacePosition = 2;
        this.currentContext = 2;
    }
}

