/*
 * Decompiled with CFR 0.152.
 */
package javax.smartcardio;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;

public class CardPermission
extends Permission {
    private static final long serialVersionUID = 7146787880530705613L;
    private static final int A_CONNECT = 1;
    private static final int A_EXCLUSIVE = 2;
    private static final int A_GET_BASIC_CHANNEL = 4;
    private static final int A_OPEN_LOGICAL_CHANNEL = 8;
    private static final int A_RESET = 16;
    private static final int A_TRANSMIT_CONTROL = 32;
    private static final int A_ALL = 63;
    private static final int[] ARRAY_MASKS = new int[]{63, 1, 2, 4, 8, 16, 32};
    private static final String S_CONNECT = "connect";
    private static final String S_EXCLUSIVE = "exclusive";
    private static final String S_GET_BASIC_CHANNEL = "getBasicChannel";
    private static final String S_OPEN_LOGICAL_CHANNEL = "openLogicalChannel";
    private static final String S_RESET = "reset";
    private static final String S_TRANSMIT_CONTROL = "transmitControl";
    private static final String S_ALL = "*";
    private static final String[] ARRAY_STRINGS = new String[]{"*", "connect", "exclusive", "getBasicChannel", "openLogicalChannel", "reset", "transmitControl"};
    private transient int mask;
    private volatile String actions;

    public CardPermission(String string, String string2) {
        super(string);
        if (string == null) {
            throw new NullPointerException();
        }
        this.mask = CardPermission.getMask(string2);
    }

    private static int getMask(String string) {
        String[] stringArray;
        int n;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("actions must not be empty");
        }
        for (n = 0; n < ARRAY_STRINGS.length; ++n) {
            if (string != ARRAY_STRINGS[n]) continue;
            return ARRAY_MASKS[n];
        }
        if (string.endsWith(",")) {
            throw new IllegalArgumentException("Invalid actions: '" + string + "'");
        }
        n = 0;
        block1: for (String string2 : stringArray = string.split(",")) {
            for (int i = 0; i < ARRAY_STRINGS.length; ++i) {
                if (!ARRAY_STRINGS[i].equalsIgnoreCase(string2)) continue;
                n |= ARRAY_MASKS[i];
                continue block1;
            }
            throw new IllegalArgumentException("Invalid action: '" + string2 + "'");
        }
        return n;
    }

    private static String getActions(int n) {
        if (n == 63) {
            return S_ALL;
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < ARRAY_MASKS.length; ++i) {
            int n2 = ARRAY_MASKS[i];
            if ((n & n2) != n2) continue;
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(ARRAY_STRINGS[i]);
        }
        return stringBuilder.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = CardPermission.getActions(this.mask);
        }
        return this.actions;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof CardPermission)) {
            return false;
        }
        CardPermission cardPermission = (CardPermission)permission;
        if ((this.mask & cardPermission.mask) != cardPermission.mask) {
            return false;
        }
        String string = this.getName();
        if (string.equals(S_ALL)) {
            return true;
        }
        return string.equals(cardPermission.getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CardPermission)) {
            return false;
        }
        CardPermission cardPermission = (CardPermission)object;
        return this.getName().equals(cardPermission.getName()) && this.mask == cardPermission.mask;
    }

    public int hashCode() {
        return this.getName().hashCode() + 31 * this.mask;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mask = CardPermission.getMask(this.actions);
    }
}

