/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.ResourceManager;
import com.sun.naming.internal.VersionHelper;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ContinuationContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.Resolver;
import javax.naming.spi.StateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingManager {
    static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static ObjectFactoryBuilder object_factory_builder = null;
    private static final String defaultPkgPrefix = "com.sun.jndi.url";
    private static InitialContextFactoryBuilder initctx_factory_builder = null;
    public static final String CPE = "java.naming.spi.CannotProceedException";

    NamingManager() {
    }

    public static synchronized void setObjectFactoryBuilder(ObjectFactoryBuilder objectFactoryBuilder) throws NamingException {
        if (object_factory_builder != null) {
            throw new IllegalStateException("ObjectFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        object_factory_builder = objectFactoryBuilder;
    }

    static synchronized ObjectFactoryBuilder getObjectFactoryBuilder() {
        return object_factory_builder;
    }

    static ObjectFactory getObjectFactoryFromReference(Reference reference, String string) throws IllegalAccessException, InstantiationException, MalformedURLException {
        String string2;
        Class clazz = null;
        try {
            clazz = helper.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && (string2 = reference.getFactoryClassLocation()) != null) {
            try {
                clazz = helper.loadClass(string, string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz != null ? (ObjectFactory)clazz.newInstance() : null;
    }

    private static Object createObjectFromFactories(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        FactoryEnumeration factoryEnumeration = ResourceManager.getFactories("java.naming.factory.object", hashtable, context);
        if (factoryEnumeration == null) {
            return null;
        }
        Object object2 = null;
        while (object2 == null && factoryEnumeration.hasMore()) {
            ObjectFactory objectFactory = (ObjectFactory)factoryEnumeration.next();
            object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        return object2;
    }

    private static String getURLScheme(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            return string.substring(0, n);
        }
        return null;
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Object object2;
        ObjectFactoryBuilder objectFactoryBuilder = NamingManager.getObjectFactoryBuilder();
        if (objectFactoryBuilder != null) {
            ObjectFactory objectFactory = objectFactoryBuilder.createObjectFactory(object, hashtable);
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (reference != null) {
            String string = reference.getFactoryClassName();
            if (string != null) {
                ObjectFactory objectFactory = NamingManager.getObjectFactoryFromReference(reference, string);
                if (objectFactory != null) {
                    return objectFactory.getObjectInstance(reference, name, context, hashtable);
                }
                return object;
            }
            object2 = NamingManager.processURLAddrs(reference, name, context, hashtable);
            if (object2 != null) {
                return object2;
            }
        }
        return (object2 = NamingManager.createObjectFromFactories(object, name, context, hashtable)) != null ? object2 : object;
    }

    static Object processURLAddrs(Reference reference, Name name, Context context, Hashtable hashtable) throws NamingException {
        for (int i = 0; i < reference.size(); ++i) {
            String string;
            Object object;
            RefAddr refAddr = reference.get(i);
            if (!(refAddr instanceof StringRefAddr) || !refAddr.getType().equalsIgnoreCase("URL") || (object = NamingManager.processURL(string = (String)refAddr.getContent(), name, context, hashtable)) == null) continue;
            return object;
        }
        return null;
    }

    private static Object processURL(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Object object2;
        String[] stringArray;
        String string;
        if (object instanceof String && (string = NamingManager.getURLScheme((String)(stringArray = (String[])object))) != null && (object2 = NamingManager.getURLObject(string, object, name, context, hashtable)) != null) {
            return object2;
        }
        if (object instanceof String[]) {
            stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = NamingManager.getURLScheme(stringArray[i]);
                if (string2 == null || (object2 = NamingManager.getURLObject(string2, object, name, context, hashtable)) == null) continue;
                return object2;
            }
        }
        return null;
    }

    static Context getContext(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Object object2;
        if (object instanceof Context) {
            return (Context)object;
        }
        try {
            object2 = NamingManager.getObjectInstance(object, name, context, hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
        return object2 instanceof Context ? (Context)object2 : null;
    }

    static Resolver getResolver(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Object object2;
        if (object instanceof Resolver) {
            return (Resolver)object;
        }
        try {
            object2 = NamingManager.getObjectInstance(object, name, context, hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
        return object2 instanceof Resolver ? (Resolver)object2 : null;
    }

    public static Context getURLContext(String string, Hashtable<?, ?> hashtable) throws NamingException {
        Object object = NamingManager.getURLObject(string, null, null, null, hashtable);
        if (object instanceof Context) {
            return (Context)object;
        }
        return null;
    }

    private static Object getURLObject(String string, Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        ObjectFactory objectFactory = (ObjectFactory)ResourceManager.getFactory("java.naming.factory.url.pkgs", hashtable, context, "." + string + "." + string + "URLContextFactory", defaultPkgPrefix);
        if (objectFactory == null) {
            return null;
        }
        try {
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private static synchronized InitialContextFactoryBuilder getInitialContextFactoryBuilder() {
        return initctx_factory_builder;
    }

    public static Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        InitialContextFactory initialContextFactory;
        InitialContextFactoryBuilder initialContextFactoryBuilder = NamingManager.getInitialContextFactoryBuilder();
        if (initialContextFactoryBuilder == null) {
            String string;
            String string2 = string = hashtable != null ? (String)hashtable.get("java.naming.factory.initial") : null;
            if (string == null) {
                NoInitialContextException noInitialContextException = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
                throw noInitialContextException;
            }
            try {
                initialContextFactory = (InitialContextFactory)helper.loadClass(string).newInstance();
            }
            catch (Exception exception) {
                NoInitialContextException noInitialContextException = new NoInitialContextException("Cannot instantiate class: " + string);
                noInitialContextException.setRootCause(exception);
                throw noInitialContextException;
            }
        } else {
            initialContextFactory = initialContextFactoryBuilder.createInitialContextFactory(hashtable);
        }
        return initialContextFactory.getInitialContext(hashtable);
    }

    public static synchronized void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws NamingException {
        if (initctx_factory_builder != null) {
            throw new IllegalStateException("InitialContextFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        initctx_factory_builder = initialContextFactoryBuilder;
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return NamingManager.getInitialContextFactoryBuilder() != null;
    }

    public static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        Hashtable<String, CannotProceedException> hashtable = cannotProceedException.getEnvironment();
        hashtable = hashtable == null ? new Hashtable<String, CannotProceedException>(7) : (Hashtable<String, CannotProceedException>)hashtable.clone();
        hashtable.put(CPE, cannotProceedException);
        ContinuationContext continuationContext = new ContinuationContext(cannotProceedException, hashtable);
        return continuationContext.getTargetContext();
    }

    public static Object getStateToBind(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        FactoryEnumeration factoryEnumeration = ResourceManager.getFactories("java.naming.factory.state", hashtable, context);
        if (factoryEnumeration == null) {
            return object;
        }
        Object object2 = null;
        while (object2 == null && factoryEnumeration.hasMore()) {
            StateFactory stateFactory = (StateFactory)factoryEnumeration.next();
            object2 = stateFactory.getStateToBind(object, name, context, hashtable);
        }
        return object2 != null ? object2 : object;
    }
}

