/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient ReentrantLock lock = new ReentrantLock();
    private volatile transient Object[] array;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long lockOffset;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] objectArray) {
        this.array = objectArray;
    }

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (objectArray.getClass() != Object[].class) {
            objectArray = Arrays.copyOf(objectArray, objectArray.length, Object[].class);
        }
        this.setArray(objectArray);
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.setArray(Arrays.copyOf(EArray, EArray.length, Object[].class));
    }

    @Override
    public int size() {
        return this.getArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int indexOf(Object object, Object[] objectArray, int n, int n2) {
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length);
    }

    public int indexOf(E e, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, objectArray, n, objectArray.length);
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, objectArray.length - 1);
    }

    public int lastIndexOf(E e, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(e, objectArray, n);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.resetLock();
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = this.getArray();
        return Arrays.copyOf(objectArray, objectArray.length);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        if (TArray.length < n) {
            return Arrays.copyOf(objectArray, n, TArray.getClass());
        }
        System.arraycopy(objectArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public E get(int n) {
        return (E)this.getArray()[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e) {
        Object object;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            Object object2 = objectArray[n];
            if (object2 != e) {
                int n2 = objectArray.length;
                Object[] objectArray2 = Arrays.copyOf(objectArray, n2);
                objectArray2[n] = e;
                this.setArray(objectArray2);
            } else {
                this.setArray(objectArray);
            }
            object = object2;
            Object var9_9 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n = objectArray.length;
            Object[] objectArray2 = Arrays.copyOf(objectArray, n + 1);
            objectArray2[n] = e;
            this.setArray(objectArray2);
            boolean bl = true;
            Object var8_7 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray;
            Object[] objectArray2 = this.getArray();
            int n2 = objectArray2.length;
            if (n > n2 || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                objectArray = Arrays.copyOf(objectArray2, n2 + 1);
            } else {
                objectArray = new Object[n2 + 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n, objectArray, n + 1, n3);
            }
            objectArray[n] = e;
            this.setArray(objectArray);
            Object var9_8 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) {
        Object[] objectArray;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray2 = this.getArray();
            int n2 = objectArray2.length;
            Object object = objectArray2[n];
            int n3 = n2 - n - 1;
            if (n3 == 0) {
                this.setArray(Arrays.copyOf(objectArray2, n2 - 1));
            } else {
                objectArray = new Object[n2 - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n + 1, objectArray, n, n3);
                this.setArray(objectArray);
            }
            objectArray = object;
            Object var9_8 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return (E)objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object object) {
        int n;
        ReentrantLock reentrantLock;
        block9: {
            int n2;
            block8: {
                reentrantLock = this.lock;
                reentrantLock.lock();
                try {
                    Object[] objectArray = this.getArray();
                    int n3 = objectArray.length;
                    if (n3 != 0) {
                        n = n3 - 1;
                        Object[] objectArray2 = new Object[n];
                        for (n2 = 0; n2 < n; n2 += 1) {
                            if (CopyOnWriteArrayList.eq(object, objectArray[n2])) {
                                int n4 = n2 + 1;
                                while (true) {
                                    if (n4 >= n3) {
                                        this.setArray(objectArray2);
                                        n4 = 1;
                                        Object var10_9 = null;
                                        reentrantLock.unlock();
                                        return n4 != 0;
                                    }
                                    objectArray2[n4 - 1] = objectArray[n4];
                                    ++n4;
                                }
                            }
                            objectArray2[n2] = objectArray[n2];
                        }
                        if (CopyOnWriteArrayList.eq(object, objectArray[n])) {
                            this.setArray(objectArray2);
                            n2 = 1;
                            break block8;
                        }
                    }
                    n = 0;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    reentrantLock.unlock();
                    throw throwable;
                }
            }
            Object var10_10 = null;
            reentrantLock.unlock();
            return n2 != 0;
        }
        Object var10_11 = null;
        reentrantLock.unlock();
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRange(int n, int n2) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n3 = objectArray.length;
            if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = n3 - (n2 - n);
            int n5 = n3 - n2;
            if (n5 == 0) {
                this.setArray(Arrays.copyOf(objectArray, n4));
            } else {
                Object[] objectArray2 = new Object[n4];
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                System.arraycopy(objectArray, n2, objectArray2, n, n5);
                this.setArray(objectArray2);
            }
            Object var10_9 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addIfAbsent(E e) {
        int n;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n2 = objectArray.length;
            Object[] objectArray2 = new Object[n2 + 1];
            for (n = 0; n < n2; ++n) {
                if (CopyOnWriteArrayList.eq(e, objectArray[n])) {
                    boolean bl = false;
                    Object var9_8 = null;
                    reentrantLock.unlock();
                    return bl;
                }
                objectArray2[n] = objectArray[n];
            }
            objectArray2[n2] = e;
            this.setArray(objectArray2);
            n = 1;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var9_9 = null;
        reentrantLock.unlock();
        return n != 0;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (Object obj : collection) {
            if (CopyOnWriteArrayList.indexOf(obj, objectArray, 0, n) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        int n;
        ReentrantLock reentrantLock;
        block4: {
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n2;
                Object[] objectArray = this.getArray();
                int n3 = objectArray.length;
                if (!n3) break block4;
                n = 0;
                Object[] objectArray2 = new Object[n3];
                for (n2 = 0; n2 < n3; n2 += 1) {
                    Object object = objectArray[n2];
                    if (collection.contains(object)) continue;
                    objectArray2[n++] = object;
                }
                if (n == n3) break block4;
                this.setArray(Arrays.copyOf(objectArray2, n));
                n2 = 1;
                Object var10_9 = null;
                reentrantLock.unlock();
                return n2 != 0;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        n = 0;
        Object var10_10 = null;
        reentrantLock.unlock();
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        int n;
        ReentrantLock reentrantLock;
        block4: {
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n2;
                Object[] objectArray = this.getArray();
                int n3 = objectArray.length;
                if (!n3) break block4;
                n = 0;
                Object[] objectArray2 = new Object[n3];
                for (n2 = 0; n2 < n3; n2 += 1) {
                    Object object = objectArray[n2];
                    if (!collection.contains(object)) continue;
                    objectArray2[n++] = object;
                }
                if (n == n3) break block4;
                this.setArray(Arrays.copyOf(objectArray2, n));
                n2 = 1;
                Object var10_9 = null;
                reentrantLock.unlock();
                return n2 != 0;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        n = 0;
        Object var10_10 = null;
        reentrantLock.unlock();
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (objectArray.length == 0) {
            return 0;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray3 = this.getArray();
            int n2 = objectArray3.length;
            int n3 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                Object object = objectArray[n];
                if (CopyOnWriteArrayList.indexOf(object, objectArray3, 0, n2) >= 0 || CopyOnWriteArrayList.indexOf(object, objectArray2, 0, n3) >= 0) continue;
                objectArray2[n3++] = object;
            }
            if (n3 > 0) {
                Object[] objectArray4 = Arrays.copyOf(objectArray3, n2 + n3);
                System.arraycopy(objectArray2, 0, objectArray4, n2, n3);
                this.setArray(objectArray4);
            }
            n = n3;
            Object var11_11 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.setArray(new Object[0]);
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (objectArray.length == 0) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray2 = this.getArray();
            int n = objectArray2.length;
            Object[] objectArray3 = Arrays.copyOf(objectArray2, n + objectArray.length);
            System.arraycopy(objectArray, 0, objectArray3, n, objectArray.length);
            this.setArray(objectArray3);
            boolean bl = true;
            Object var9_8 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        ReentrantLock reentrantLock;
        Object[] objectArray3;
        block6: {
            objectArray3 = collection.toArray();
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                objectArray2 = this.getArray();
                n2 = objectArray2.length;
                if (n > n2 || n < 0) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
                }
                if (objectArray3.length != 0) break block6;
                boolean bl = false;
                Object var11_9 = null;
                reentrantLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            objectArray = Arrays.copyOf(objectArray2, n2 + objectArray3.length);
        } else {
            objectArray = new Object[n2 + objectArray3.length];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            System.arraycopy(objectArray2, n, objectArray, n + objectArray3.length, n3);
        }
        System.arraycopy(objectArray3, 0, objectArray, n, objectArray3.length);
        this.setArray(objectArray);
        boolean bl = true;
        Object var11_10 = null;
        reentrantLock.unlock();
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(objectArray[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.resetLock();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        this.setArray(objectArray);
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        Iterator iterator = list.iterator();
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (iterator.hasNext() && CopyOnWriteArrayList.eq(objectArray[i], iterator.next())) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object object : this.getArray()) {
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        Object[] objectArray = this.getArray();
        int n2 = objectArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(objectArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int n, int n2) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n3 = objectArray.length;
            if (n < 0 || n2 > n3 || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            COWSubList cOWSubList = new COWSubList(this, n, n2);
            Object var8_7 = null;
            reentrantLock.unlock();
            return cOWSubList;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    private void resetLock() {
        unsafe.putObjectVolatile(this, lockOffset, new ReentrantLock());
    }

    static {
        try {
            lockOffset = unsafe.objectFieldOffset(CopyOnWriteArrayList.class.getDeclaredField("lock"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] objectArray, int n) {
            this.cursor = n;
            this.snapshot = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWSubList<E>
    extends AbstractList<E> {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        private COWSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.getArray();
            this.offset = n;
            this.size = n2 - n;
        }

        private void checkForComodification() {
            if (this.l.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            E e2;
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                E e3 = this.l.set(n + this.offset, e);
                this.expectedArray = this.l.getArray();
                e2 = e3;
                Object var7_6 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            E e;
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                e = this.l.get(n + this.offset);
                Object var5_4 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                int n = this.size;
                Object var4_3 = null;
                reentrantLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, e);
                this.expectedArray = this.l.getArray();
                ++this.size;
                Object var5_4 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                ((CopyOnWriteArrayList)this.l).removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
                Object var3_2 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            E e;
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                E e2 = this.l.remove(n + this.offset);
                this.expectedArray = this.l.getArray();
                --this.size;
                e = e2;
                Object var6_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                COWSubListIterator cOWSubListIterator = new COWSubListIterator(this.l, 0, this.offset, this.size);
                Object var4_3 = null;
                reentrantLock.unlock();
                return cOWSubListIterator;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                COWSubListIterator cOWSubListIterator = new COWSubListIterator(this.l, n, this.offset, this.size);
                Object var5_4 = null;
                reentrantLock.unlock();
                return cOWSubListIterator;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                COWSubList<E> cOWSubList = new COWSubList<E>(this.l, n + this.offset, n2 + this.offset);
                Object var6_5 = null;
                reentrantLock.unlock();
                return cOWSubList;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> i;
        private final int index;
        private final int offset;
        private final int size;

        private COWSubListIterator(List<E> list, int n, int n2, int n3) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.i = list.listIterator(n + n2);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

