/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileKey;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

public class FileChannelImpl
extends FileChannel {
    private static NativeDispatcher nd;
    private static long allocationGranularity;
    private FileDescriptor fd;
    private boolean writable;
    private boolean readable;
    private boolean appending;
    private Object parent;
    private NativeThreadSet threads = new NativeThreadSet(2);
    private Object positionLock = new Object();
    private static volatile boolean transferSupported;
    private static volatile boolean pipeSupported;
    private static volatile boolean fileSupported;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    public static final int NO_LOCK = -1;
    public static final int LOCKED = 0;
    public static final int RET_EX_LOCK = 1;
    public static final int INTERRUPTED = 2;
    private volatile FileLockTable fileLockTable;
    private static boolean isSharedFileLockTable;
    private static volatile boolean propertyChecked;

    private FileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object, boolean bl3) {
        this.fd = fileDescriptor;
        this.readable = bl;
        this.writable = bl2;
        this.parent = object;
        this.appending = bl3;
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object) {
        return new FileChannelImpl(fileDescriptor, bl, bl2, object, false);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object, boolean bl3) {
        return new FileChannelImpl(fileDescriptor, bl, bl2, object, bl3);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    protected void implCloseChannel() throws IOException {
        nd.preClose(this.fd);
        this.threads.signal();
        if (this.fileLockTable != null) {
            this.fileLockTable.removeAll(new FileLockTable.Releaser(){

                public void release(FileLock fileLock) throws IOException {
                    ((FileLockImpl)fileLock).invalidate();
                    FileChannelImpl.this.release0(FileChannelImpl.this.fd, fileLock.position(), fileLock.size());
                }
            });
        }
        if (this.parent != null) {
            if (this.parent instanceof FileInputStream) {
                ((FileInputStream)this.parent).close();
            } else if (this.parent instanceof FileOutputStream) {
                ((FileOutputStream)this.parent).close();
            } else if (this.parent instanceof RandomAccessFile) {
                ((RandomAccessFile)this.parent).close();
            } else assert (false);
        } else {
            nd.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            block12: {
                boolean bl;
                int n4;
                block11: {
                    n3 = 0;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n4 = 0;
                            Object var7_7 = null;
                            this.threads.remove(n2);
                            bl = n3 > 0;
                            break block11;
                        }
                        n2 = this.threads.add();
                        while ((n3 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.positionLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n3);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.threads.remove(n2);
                        this.end(n3 > 0);
                        assert (IOStatus.check(n3));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n3));
                return n4;
            }
            Object var7_8 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int n;
            long l2;
            block12: {
                boolean bl;
                long l3;
                block11: {
                    l2 = 0L;
                    n = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var9_7 = null;
                            this.threads.remove(n);
                            bl = l2 > 0L;
                            break block11;
                        }
                        n = this.threads.add();
                        while ((l2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(n);
                        this.end(l2 > 0L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var9_8 = null;
            this.threads.remove(n);
            this.end(l2 > 0L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            block13: {
                boolean bl;
                int n4;
                block12: {
                    n3 = 0;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n4 = 0;
                            Object var7_7 = null;
                            this.threads.remove(n2);
                            bl = n3 > 0;
                            break block12;
                        }
                        n2 = this.threads.add();
                        if (this.appending) {
                            this.position(this.size());
                        }
                        while ((n3 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.positionLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n3);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.threads.remove(n2);
                        this.end(n3 > 0);
                        assert (IOStatus.check(n3));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n3));
                return n4;
            }
            Object var7_8 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int n;
            long l2;
            block13: {
                boolean bl;
                long l3;
                block12: {
                    l2 = 0L;
                    n = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var9_7 = null;
                            this.threads.remove(n);
                            bl = l2 > 0L;
                            break block12;
                        }
                        n = this.threads.add();
                        if (this.appending) {
                            this.position(this.size());
                        }
                        while ((l2 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(n);
                        this.end(l2 > 0L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var9_8 = null;
            this.threads.remove(n);
            this.end(l2 > 0L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int n;
            long l2;
            block11: {
                boolean bl;
                long l3;
                block10: {
                    l2 = -1L;
                    n = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var8_6 = null;
                            this.threads.remove(n);
                            bl = l2 > -1L;
                            break block10;
                        }
                        n = this.threads.add();
                        while ((l2 = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.threads.remove(n);
                        this.end(l2 > -1L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var8_7 = null;
            this.threads.remove(n);
            this.end(l2 > -1L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel position(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int n;
            long l2;
            block12: {
                boolean bl;
                FileChannel fileChannel;
                block11: {
                    l2 = -1L;
                    n = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            fileChannel = null;
                            Object var9_7 = null;
                            this.threads.remove(n);
                            bl = l2 > -1L;
                            break block11;
                        }
                        n = this.threads.add();
                        while ((l2 = this.position0(this.fd, l)) == -3L && this.isOpen()) {
                        }
                        fileChannelImpl = this;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(n);
                        this.end(l2 > -1L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return fileChannel;
            }
            Object var9_8 = null;
            this.threads.remove(n);
            this.end(l2 > -1L);
            assert (IOStatus.check(l2));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int n;
            long l2;
            block11: {
                boolean bl;
                long l3;
                block10: {
                    l2 = -1L;
                    n = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = -1L;
                            Object var8_6 = null;
                            this.threads.remove(n);
                            bl = l2 > -1L;
                            break block10;
                        }
                        n = this.threads.add();
                        while ((l2 = this.size0(this.fd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.threads.remove(n);
                        this.end(l2 > -1L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var8_7 = null;
            this.threads.remove(n);
            this.end(l2 > -1L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel truncate(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l > this.size()) {
            return this;
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int n;
            int n2;
            block14: {
                boolean bl;
                FileChannel fileChannel;
                block13: {
                    n2 = -1;
                    n = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            fileChannel = null;
                            Object var8_7 = null;
                            this.threads.remove(n);
                            bl = n2 > -1;
                            break block13;
                        }
                        n = this.threads.add();
                        while ((n2 = this.truncate0(this.fd, l)) == -3 && this.isOpen()) {
                        }
                        fileChannelImpl = this;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.threads.remove(n);
                        this.end(n2 > -1);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return fileChannel;
            }
            Object var8_8 = null;
            this.threads.remove(n);
            this.end(n2 > -1);
            assert (IOStatus.check(n2));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void force(boolean bl) throws IOException {
        int n;
        int n2;
        block8: {
            boolean bl2;
            block7: {
                this.ensureOpen();
                n2 = -1;
                n = -1;
                try {
                    this.begin();
                    if (!this.isOpen()) {
                        Object var5_4 = null;
                        this.threads.remove(n);
                        bl2 = n2 > -1;
                        break block7;
                    }
                    n = this.threads.add();
                    while ((n2 = this.force0(this.fd, bl)) == -3) {
                        if (this.isOpen()) continue;
                        break block8;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.threads.remove(n);
                    this.end(n2 > -1);
                    assert (IOStatus.check(n2));
                    throw throwable;
                }
            }
            this.end(bl2);
            assert (IOStatus.check(n2));
            return;
        }
        Object var5_5 = null;
        this.threads.remove(n);
        this.end(n2 > -1);
        assert (IOStatus.check(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        int n2;
        long l2;
        block18: {
            block17: {
                long l3;
                int n3;
                int n4;
                block16: {
                    if (!transferSupported) {
                        return -4L;
                    }
                    FileDescriptor fileDescriptor = null;
                    if (writableByteChannel instanceof FileChannelImpl) {
                        if (!fileSupported) {
                            return -6L;
                        }
                        fileDescriptor = ((FileChannelImpl)writableByteChannel).fd;
                    } else if (writableByteChannel instanceof SelChImpl) {
                        if (writableByteChannel instanceof SinkChannelImpl && !pipeSupported) {
                            return -6L;
                        }
                        fileDescriptor = ((SelChImpl)((Object)writableByteChannel)).getFD();
                    }
                    if (fileDescriptor == null) {
                        return -4L;
                    }
                    n4 = IOUtil.fdVal(this.fd);
                    if (n4 == (n3 = IOUtil.fdVal(fileDescriptor))) {
                        return -4L;
                    }
                    l2 = -1L;
                    n2 = -1;
                    this.begin();
                    if (this.isOpen()) break block16;
                    long l4 = -1L;
                    Object var14_13 = null;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                    return l4;
                }
                try {
                    n2 = this.threads.add();
                    while ((l2 = this.transferTo0(n4, l, n, n3)) == -3L && this.isOpen()) {
                    }
                    if (l2 != -6L) break block17;
                    if (writableByteChannel instanceof SinkChannelImpl) {
                        pipeSupported = false;
                    }
                    if (writableByteChannel instanceof FileChannelImpl) {
                        fileSupported = false;
                    }
                    l3 = -6L;
                    Object var14_14 = null;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                    throw throwable;
                }
                return l3;
            }
            if (l2 != -4L) break block18;
            transferSupported = false;
            long l5 = -4L;
            Object var14_15 = null;
            this.threads.remove(n2);
            this.end(l2 > -1L);
            return l5;
        }
        long l6 = IOStatus.normalize(l2);
        Object var14_16 = null;
        this.threads.remove(n2);
        this.end(l2 > -1L);
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        long l2;
        block3: {
            if (!(writableByteChannel instanceof FileChannelImpl) && !(writableByteChannel instanceof SelChImpl)) {
                return -4L;
            }
            MappedByteBuffer mappedByteBuffer = null;
            try {
                mappedByteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l, n);
                l2 = writableByteChannel.write(mappedByteBuffer);
                Object var9_6 = null;
                if (mappedByteBuffer == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_7 = null;
                    if (mappedByteBuffer == null) break block4;
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
                throw throwable;
            }
            FileChannelImpl.unmap(mappedByteBuffer);
        }
        return l2;
    }

    private long transferToArbitraryChannel(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        long l2;
        int n2 = Math.min(n, 8192);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n2);
        long l3 = 0L;
        long l4 = l;
        try {
            Util.erase(byteBuffer);
            while (l3 < (long)n) {
                byteBuffer.limit(Math.min((int)((long)n - l3), 8192));
                int n3 = this.read(byteBuffer, l4);
                if (n3 <= 0) break;
                byteBuffer.flip();
                int n4 = writableByteChannel.write(byteBuffer);
                l3 += (long)n4;
                if (n4 != n3) break;
                l4 += (long)n4;
                byteBuffer.clear();
            }
            l2 = l3;
            Object var15_13 = null;
        }
        catch (IOException iOException) {
            block6: {
                long l5;
                try {
                    if (l3 <= 0L) break block6;
                    l5 = l3;
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    Util.releaseTemporaryDirectBuffer(byteBuffer);
                    throw throwable;
                }
                Util.releaseTemporaryDirectBuffer(byteBuffer);
                return l5;
            }
            throw iOException;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer);
        return l2;
    }

    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        long l3;
        this.ensureOpen();
        if (!writableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (writableByteChannel instanceof FileChannelImpl && !((FileChannelImpl)writableByteChannel).writable) {
            throw new NonWritableChannelException();
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        long l4 = this.size();
        if (l > l4) {
            return 0L;
        }
        int n = (int)Math.min(l2, Integer.MAX_VALUE);
        if (l4 - l < (long)n) {
            n = (int)(l4 - l);
        }
        if ((l3 = this.transferToDirectly(l, n, writableByteChannel)) >= 0L) {
            return l3;
        }
        l3 = this.transferToTrustedChannel(l, n, writableByteChannel);
        if (l3 >= 0L) {
            return l3;
        }
        return this.transferToArbitraryChannel(l, n, writableByteChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long transferFromFileChannel(FileChannelImpl fileChannelImpl, long l, long l2) throws IOException {
        Object object = fileChannelImpl.positionLock;
        synchronized (object) {
            long l3;
            long l4 = fileChannelImpl.position();
            int n = (int)Math.min(Math.min(l2, Integer.MAX_VALUE), fileChannelImpl.size() - l4);
            MappedByteBuffer mappedByteBuffer = fileChannelImpl.map(FileChannel.MapMode.READ_ONLY, l4, n);
            try {
                long l5 = this.write(mappedByteBuffer, l);
                fileChannelImpl.position(l4 + l5);
                l3 = l5;
                Object var16_10 = null;
            }
            catch (Throwable throwable) {
                Object var16_11 = null;
                FileChannelImpl.unmap(mappedByteBuffer);
                throw throwable;
            }
            FileChannelImpl.unmap(mappedByteBuffer);
            return l3;
        }
    }

    private long transferFromArbitraryChannel(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        long l3;
        int n = (int)Math.min(l2, 8192L);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n);
        long l4 = 0L;
        long l5 = l;
        try {
            Util.erase(byteBuffer);
            while (l4 < l2) {
                byteBuffer.limit((int)Math.min(l2 - l4, 8192L));
                int n2 = readableByteChannel.read(byteBuffer);
                if (n2 <= 0) break;
                byteBuffer.flip();
                int n3 = this.write(byteBuffer, l5);
                l4 += (long)n3;
                if (n3 != n2) break;
                l5 += (long)n3;
                byteBuffer.clear();
            }
            l3 = l4;
            Object var16_13 = null;
        }
        catch (IOException iOException) {
            block6: {
                long l6;
                try {
                    if (l4 <= 0L) break block6;
                    l6 = l4;
                    Object var16_14 = null;
                }
                catch (Throwable throwable) {
                    Object var16_15 = null;
                    Util.releaseTemporaryDirectBuffer(byteBuffer);
                    throw throwable;
                }
                Util.releaseTemporaryDirectBuffer(byteBuffer);
                return l6;
            }
            throw iOException;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer);
        return l3;
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        this.ensureOpen();
        if (!readableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l > this.size()) {
            return 0L;
        }
        if (readableByteChannel instanceof FileChannelImpl) {
            return this.transferFromFileChannel((FileChannelImpl)readableByteChannel, l, l2);
        }
        return this.transferFromArbitraryChannel(readableByteChannel, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        int n;
        int n2;
        int n3;
        block10: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            if (l < 0L) {
                throw new IllegalArgumentException("Negative position");
            }
            if (!this.readable) {
                throw new NonReadableChannelException();
            }
            this.ensureOpen();
            n3 = 0;
            n2 = -1;
            this.begin();
            if (this.isOpen()) break block10;
            int n4 = -1;
            Object var8_7 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            return n4;
        }
        try {
            n2 = this.threads.add();
            while ((n3 = IOUtil.read(this.fd, byteBuffer, l, nd, this.positionLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n3);
            Object var8_8 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            throw throwable;
        }
        assert (IOStatus.check(n3));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        int n;
        int n2;
        int n3;
        block10: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            if (l < 0L) {
                throw new IllegalArgumentException("Negative position");
            }
            if (!this.writable) {
                throw new NonWritableChannelException();
            }
            this.ensureOpen();
            n3 = 0;
            n2 = -1;
            this.begin();
            if (this.isOpen()) break block10;
            int n4 = -1;
            Object var8_7 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            return n4;
        }
        try {
            n2 = this.threads.add();
            while ((n3 = IOUtil.write(this.fd, byteBuffer, l, nd, this.positionLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n3);
            Object var8_8 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.threads.remove(n2);
            this.end(n3 > 0);
            assert (IOStatus.check(n3));
            throw throwable;
        }
        assert (IOStatus.check(n3));
        return n;
    }

    private static void unmap(MappedByteBuffer mappedByteBuffer) {
        Cleaner cleaner = ((DirectBuffer)((Object)mappedByteBuffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        Unmapper unmapper;
        int n;
        int n2;
        int n3;
        long l3;
        block31: {
            int n4;
            block29: {
                block30: {
                    MappedByteBuffer mappedByteBuffer;
                    block28: {
                        this.ensureOpen();
                        if (l < 0L) {
                            throw new IllegalArgumentException("Negative position");
                        }
                        if (l2 < 0L) {
                            throw new IllegalArgumentException("Negative size");
                        }
                        if (l + l2 < 0L) {
                            throw new IllegalArgumentException("Position + size overflow");
                        }
                        if (l2 > Integer.MAX_VALUE) {
                            throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
                        }
                        n4 = -1;
                        if (mapMode == FileChannel.MapMode.READ_ONLY) {
                            n4 = 0;
                        } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
                            n4 = 1;
                        } else if (mapMode == FileChannel.MapMode.PRIVATE) {
                            n4 = 2;
                        }
                        assert (n4 >= 0);
                        if (mapMode != FileChannel.MapMode.READ_ONLY && !this.writable) {
                            throw new NonWritableChannelException();
                        }
                        if (!this.readable) {
                            throw new NonReadableChannelException();
                        }
                        l3 = -1L;
                        n3 = -1;
                        this.begin();
                        if (this.isOpen()) break block28;
                        MappedByteBuffer mappedByteBuffer2 = null;
                        Object var19_11 = null;
                        this.threads.remove(n3);
                        this.end(IOStatus.checkAll(l3));
                        return mappedByteBuffer2;
                    }
                    try {
                        n3 = this.threads.add();
                        if (this.size() < l + l2) {
                            while ((n2 = this.truncate0(this.fd, l + l2)) == -3 && this.isOpen()) {
                            }
                        }
                        if (l2 != 0L) break block29;
                        l3 = 0L;
                        if (this.writable && n4 != 0) break block30;
                        mappedByteBuffer = Util.newMappedByteBufferR(0, 0L, null);
                        Object var19_12 = null;
                        this.threads.remove(n3);
                    }
                    catch (Throwable throwable) {
                        Object var19_16 = null;
                        this.threads.remove(n3);
                        this.end(IOStatus.checkAll(l3));
                        throw throwable;
                    }
                    this.end(IOStatus.checkAll(l3));
                    return mappedByteBuffer;
                }
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(0, 0L, null);
                Object var19_13 = null;
                this.threads.remove(n3);
                this.end(IOStatus.checkAll(l3));
                return mappedByteBuffer;
            }
            n2 = (int)(l % allocationGranularity);
            long l4 = l - (long)n2;
            long l5 = l2 + (long)n2;
            try {
                l3 = this.map0(n4, l4, l5);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                try {
                    l3 = this.map0(n4, l4, l5);
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    throw new IOException("Map failed", outOfMemoryError2);
                }
            }
            assert (IOStatus.checkAll(l3));
            assert (l3 % allocationGranularity == 0L);
            n = (int)l2;
            unmapper = new Unmapper(l3, l2 + (long)n2);
            if (this.writable && n4 != 0) break block31;
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(n, l3 + (long)n2, unmapper);
            Object var19_14 = null;
            this.threads.remove(n3);
            this.end(IOStatus.checkAll(l3));
            return mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(n, l3 + (long)n2, unmapper);
        Object var19_15 = null;
        this.threads.remove(n3);
        this.end(IOStatus.checkAll(l3));
        return mappedByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSharedFileLockTable() {
        if (propertyChecked) return isSharedFileLockTable;
        Class<FileChannelImpl> clazz = FileChannelImpl.class;
        synchronized (FileChannelImpl.class) {
            if (propertyChecked) return isSharedFileLockTable;
            GetPropertyAction getPropertyAction = new GetPropertyAction("sun.nio.ch.disableSystemWideOverlappingFileLockCheck");
            String string = AccessController.doPrivileged(getPropertyAction);
            isSharedFileLockTable = string == null || string.equals("false");
            propertyChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isSharedFileLockTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockTable fileLockTable() {
        if (this.fileLockTable == null) {
            FileChannelImpl fileChannelImpl = this;
            synchronized (fileChannelImpl) {
                if (this.fileLockTable == null) {
                    this.fileLockTable = FileChannelImpl.isSharedFileLockTable() ? new SharedFileLockTable(this) : new SimpleFileLockTable();
                }
            }
        }
        return this.fileLockTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        int n;
        boolean bl2;
        FileLockImpl fileLockImpl;
        block17: {
            FileLockImpl fileLockImpl3;
            block16: {
                FileLock fileLock;
                block15: {
                    this.ensureOpen();
                    if (bl && !this.readable) {
                        throw new NonReadableChannelException();
                    }
                    if (!bl && !this.writable) {
                        throw new NonWritableChannelException();
                    }
                    fileLockImpl = new FileLockImpl(this, l, l2, bl);
                    FileLockTable fileLockTable = this.fileLockTable();
                    fileLockTable.add(fileLockImpl);
                    bl2 = true;
                    n = -1;
                    try {
                        try {
                            this.begin();
                            if (!this.isOpen()) {
                                fileLock = null;
                                Object var14_11 = null;
                                this.threads.remove(n);
                                break block15;
                            }
                            n = this.threads.add();
                            int n2 = this.lock0(this.fd, true, l, l2, bl);
                            if (n2 == 1) {
                                assert (bl);
                                FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
                                fileLockTable.replace(fileLockImpl, fileLockImpl2);
                                fileLockImpl3 = fileLockImpl2;
                                break block16;
                            }
                            if (n2 == 2 || n2 == -1) {
                                fileLockTable.remove(fileLockImpl);
                                bl2 = false;
                            }
                            break block17;
                        }
                        catch (IOException iOException) {
                            fileLockTable.remove(fileLockImpl);
                            throw iOException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        this.threads.remove(n);
                        try {
                            this.end(bl2);
                            throw throwable;
                        }
                        catch (ClosedByInterruptException closedByInterruptException) {
                            throw new FileLockInterruptionException();
                        }
                    }
                }
                try {}
                catch (ClosedByInterruptException closedByInterruptException) {
                    throw new FileLockInterruptionException();
                }
                this.end(bl2);
                return fileLock;
            }
            Object var14_12 = null;
            this.threads.remove(n);
            try {}
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new FileLockInterruptionException();
            }
            this.end(bl2);
            return fileLockImpl3;
        }
        Object var14_13 = null;
        this.threads.remove(n);
        try {}
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new FileLockInterruptionException();
        }
        this.end(bl2);
        return fileLockImpl;
    }

    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        int n;
        this.ensureOpen();
        if (bl && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l, l2, bl);
        FileLockTable fileLockTable = this.fileLockTable();
        fileLockTable.add(fileLockImpl);
        try {
            n = this.lock0(this.fd, false, l, l2, bl);
        }
        catch (IOException iOException) {
            fileLockTable.remove(fileLockImpl);
            throw iOException;
        }
        if (n == -1) {
            fileLockTable.remove(fileLockImpl);
            return null;
        }
        if (n == 1) {
            assert (bl);
            FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
            fileLockTable.replace(fileLockImpl, fileLockImpl2);
            return fileLockImpl2;
        }
        return fileLockImpl;
    }

    void release(FileLockImpl fileLockImpl) throws IOException {
        this.ensureOpen();
        this.release0(this.fd, fileLockImpl.position(), fileLockImpl.size());
        assert (this.fileLockTable != null);
        this.fileLockTable.remove(fileLockImpl);
    }

    native int lock0(FileDescriptor var1, boolean var2, long var3, long var5, boolean var7) throws IOException;

    native void release0(FileDescriptor var1, long var2, long var4) throws IOException;

    private native long map0(int var1, long var2, long var4) throws IOException;

    private static native int unmap0(long var0, long var2);

    private native int force0(FileDescriptor var1, boolean var2);

    private native int truncate0(FileDescriptor var1, long var2);

    private native long transferTo0(int var1, long var2, long var4, int var6);

    private native long position0(FileDescriptor var1, long var2);

    private native long size0(FileDescriptor var1);

    private static native long initIDs();

    static {
        transferSupported = true;
        pipeSupported = true;
        fileSupported = true;
        Util.load();
        allocationGranularity = FileChannelImpl.initIDs();
        nd = new FileDispatcher();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileLockReference
    extends WeakReference<FileLock> {
        private FileKey fileKey;

        FileLockReference(FileLock fileLock, ReferenceQueue referenceQueue, FileKey fileKey) {
            super(fileLock, referenceQueue);
            this.fileKey = fileKey;
        }

        private FileKey fileKey() {
            return this.fileKey;
        }
    }

    private static interface FileLockTable {
        public void add(FileLock var1) throws OverlappingFileLockException;

        public void remove(FileLock var1);

        public void removeAll(Releaser var1) throws IOException;

        public void replace(FileLock var1, FileLock var2);

        public static interface Releaser {
            public void release(FileLock var1) throws IOException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SharedFileLockTable
    implements FileLockTable {
        private static ConcurrentHashMap<FileKey, ArrayList<FileLockReference>> lockMap = new ConcurrentHashMap();
        private static ReferenceQueue queue = new ReferenceQueue();
        private FileChannelImpl fci;
        private FileKey fileKey;

        public SharedFileLockTable(FileChannelImpl fileChannelImpl) {
            this.fci = fileChannelImpl;
            this.fileKey = FileKey.create(fileChannelImpl.fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(FileLock fileLock) throws OverlappingFileLockException {
            ArrayList<FileLockReference> arrayList = lockMap.get(this.fileKey);
            while (true) {
                ArrayList<FileLockReference> arrayList2;
                ArrayList<FileLockReference> arrayList3;
                if (arrayList == null) {
                    arrayList3 = arrayList = new ArrayList(2);
                    synchronized (arrayList3) {
                        arrayList2 = lockMap.putIfAbsent(this.fileKey, arrayList);
                        if (arrayList2 == null) {
                            arrayList.add(new FileLockReference(fileLock, queue, this.fileKey));
                            break;
                        }
                    }
                    arrayList = arrayList2;
                }
                arrayList2 = arrayList;
                synchronized (arrayList2) {
                    arrayList3 = lockMap.get(this.fileKey);
                    if (arrayList == arrayList3) {
                        this.checkList(arrayList, fileLock.position(), fileLock.size());
                        arrayList.add(new FileLockReference(fileLock, queue, this.fileKey));
                        break;
                    }
                    arrayList = arrayList3;
                }
            }
            this.removeStaleEntries();
        }

        private void removeKeyIfEmpty(FileKey fileKey, ArrayList<FileLockReference> arrayList) {
            assert (Thread.holdsLock(arrayList));
            assert (lockMap.get(fileKey) == arrayList);
            if (arrayList.isEmpty()) {
                lockMap.remove(fileKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(FileLock fileLock) {
            assert (fileLock != null);
            ArrayList<FileLockReference> arrayList = lockMap.get(this.fileKey);
            assert (arrayList != null);
            ArrayList<FileLockReference> arrayList2 = arrayList;
            synchronized (arrayList2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FileLockReference fileLockReference = arrayList.get(i);
                    FileLock fileLock2 = (FileLock)fileLockReference.get();
                    if (fileLock2 != fileLock) continue;
                    assert (fileLock2 != null && fileLock2.channel() == this.fci);
                    fileLockReference.clear();
                    arrayList.remove(i);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAll(FileLockTable.Releaser releaser) throws IOException {
            ArrayList<FileLockReference> arrayList = lockMap.get(this.fileKey);
            if (arrayList != null) {
                ArrayList<FileLockReference> arrayList2 = arrayList;
                synchronized (arrayList2) {
                    int n = 0;
                    while (n < arrayList.size()) {
                        FileLockReference fileLockReference = arrayList.get(n);
                        FileLock fileLock = (FileLock)fileLockReference.get();
                        if (fileLock != null && fileLock.channel() == this.fci) {
                            releaser.release(fileLock);
                            fileLockReference.clear();
                            arrayList.remove(n);
                            continue;
                        }
                        ++n;
                    }
                    this.removeKeyIfEmpty(this.fileKey, arrayList);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(FileLock fileLock, FileLock fileLock2) {
            ArrayList<FileLockReference> arrayList = lockMap.get(this.fileKey);
            assert (arrayList != null);
            ArrayList<FileLockReference> arrayList2 = arrayList;
            synchronized (arrayList2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FileLockReference fileLockReference = arrayList.get(i);
                    FileLock fileLock3 = (FileLock)fileLockReference.get();
                    if (fileLock3 != fileLock) continue;
                    fileLockReference.clear();
                    arrayList.set(i, new FileLockReference(fileLock2, queue, this.fileKey));
                    break;
                }
            }
        }

        private void checkList(List<FileLockReference> list, long l, long l2) throws OverlappingFileLockException {
            assert (Thread.holdsLock(list));
            for (FileLockReference fileLockReference : list) {
                FileLock fileLock = (FileLock)fileLockReference.get();
                if (fileLock == null || !fileLock.overlaps(l, l2)) continue;
                throw new OverlappingFileLockException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeStaleEntries() {
            FileLockReference fileLockReference;
            while ((fileLockReference = (FileLockReference)queue.poll()) != null) {
                FileKey fileKey = fileLockReference.fileKey();
                ArrayList<FileLockReference> arrayList = lockMap.get(fileKey);
                if (arrayList == null) continue;
                ArrayList<FileLockReference> arrayList2 = arrayList;
                synchronized (arrayList2) {
                    arrayList.remove(fileLockReference);
                    this.removeKeyIfEmpty(fileKey, arrayList);
                }
            }
        }
    }

    private static class SimpleFileLockTable
    implements FileLockTable {
        private List<FileLock> lockList = new ArrayList<FileLock>(2);

        private void checkList(long l, long l2) throws OverlappingFileLockException {
            assert (Thread.holdsLock(this.lockList));
            for (FileLock fileLock : this.lockList) {
                if (!fileLock.overlaps(l, l2)) continue;
                throw new OverlappingFileLockException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FileLock fileLock) throws OverlappingFileLockException {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.checkList(fileLock.position(), fileLock.size());
                this.lockList.add(fileLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(FileLock fileLock) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fileLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll(FileLockTable.Releaser releaser) throws IOException {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                Iterator<FileLock> iterator = this.lockList.iterator();
                while (iterator.hasNext()) {
                    FileLock fileLock = iterator.next();
                    releaser.release(fileLock);
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replace(FileLock fileLock, FileLock fileLock2) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fileLock);
                this.lockList.add(fileLock2);
            }
        }
    }

    private static class Unmapper
    implements Runnable {
        private long address;
        private long size;

        private Unmapper(long l, long l2) {
            assert (l != 0L);
            this.address = l;
            this.size = l2;
        }

        public void run() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
        }
    }
}

