/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSkipListSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143111061671589L;
    private final ConcurrentNavigableMap<E, Object> m;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long mapOffset;

    public ConcurrentSkipListSet() {
        this.m = new ConcurrentSkipListMap<E, Object>();
    }

    public ConcurrentSkipListSet(Comparator<? super E> comparator) {
        this.m = new ConcurrentSkipListMap<E, Object>(comparator);
    }

    public ConcurrentSkipListSet(Collection<? extends E> collection) {
        this.m = new ConcurrentSkipListMap<E, Object>();
        this.addAll(collection);
    }

    public ConcurrentSkipListSet(SortedSet<E> sortedSet) {
        this.m = new ConcurrentSkipListMap<E, Object>(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    ConcurrentSkipListSet(ConcurrentNavigableMap<E, Object> concurrentNavigableMap) {
        this.m = concurrentNavigableMap;
    }

    public ConcurrentSkipListSet<E> clone() {
        ConcurrentSkipListSet concurrentSkipListSet = null;
        try {
            concurrentSkipListSet = (ConcurrentSkipListSet)super.clone();
            concurrentSkipListSet.setMap(new ConcurrentSkipListMap<E, Object>(this.m));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return concurrentSkipListSet;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.m.putIfAbsent(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.m.remove(object, Boolean.TRUE);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)object;
        try {
            return this.containsAll(collection) && collection.containsAll(this);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public E lower(E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.m.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.m.higherKey(e);
    }

    @Override
    public E pollFirst() {
        Map.Entry entry = this.m.pollFirstEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry entry = this.m.pollLastEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
        return new ConcurrentSkipListSet<E>(this.m.subMap(e, bl, e2, bl2));
    }

    @Override
    public NavigableSet<E> headSet(E e, boolean bl) {
        return new ConcurrentSkipListSet<E>(this.m.headMap(e, bl));
    }

    @Override
    public NavigableSet<E> tailSet(E e, boolean bl) {
        return new ConcurrentSkipListSet<E>(this.m.tailMap(e, bl));
    }

    @Override
    public NavigableSet<E> subSet(E e, E e2) {
        return this.subSet(e, true, e2, false);
    }

    @Override
    public NavigableSet<E> headSet(E e) {
        return this.headSet(e, false);
    }

    @Override
    public NavigableSet<E> tailSet(E e) {
        return this.tailSet(e, true);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new ConcurrentSkipListSet<E>(this.m.descendingMap());
    }

    private void setMap(ConcurrentNavigableMap<E, Object> concurrentNavigableMap) {
        unsafe.putObjectVolatile(this, mapOffset, concurrentNavigableMap);
    }

    static {
        try {
            mapOffset = unsafe.objectFieldOffset(ConcurrentSkipListSet.class.getDeclaredField("m"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

