/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Depth;
import sun.awt.X11.Native;
import sun.awt.X11.Visual;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Screen
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 80 : 128;
    }

    public int getDataSize() {
        return Screen.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    Screen(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    Screen() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Screen.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(n * (XlibWrapper.dataModel == 32 ? 16 : 32))) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_display(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8)) + (long)(n * Native.getLongSize());
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_display(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), l);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 28));
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 28), n);
    }

    public int get_mwidth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 32));
    }

    public void set_mwidth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 32), n);
    }

    public int get_mheight() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 36));
    }

    public void set_mheight(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 36), n);
    }

    public int get_ndepths() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 40));
    }

    public void set_ndepths(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 40), n);
    }

    public Depth get_depths(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48)) != 0L ? new Depth(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48)) + (long)(n * (XlibWrapper.dataModel == 32 ? 12 : 16))) : null;
    }

    public long get_depths() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48));
    }

    public void set_depths(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48), l);
    }

    public int get_root_depth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 56));
    }

    public void set_root_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 56), n);
    }

    public Visual get_root_visual(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64)) != 0L ? new Visual(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64)) + (long)(n * (XlibWrapper.dataModel == 32 ? 32 : 56))) : null;
    }

    public long get_root_visual() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64));
    }

    public void set_root_visual(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64), l);
    }

    public long get_default_gc() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 72));
    }

    public void set_default_gc(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 72), l);
    }

    public long get_cmap() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 80));
    }

    public void set_cmap(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 80), l);
    }

    public long get_white_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 88));
    }

    public void set_white_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 88), l);
    }

    public long get_black_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 96));
    }

    public void set_black_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 96), l);
    }

    public int get_max_maps() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 104));
    }

    public void set_max_maps(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 104), n);
    }

    public int get_min_maps() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 108));
    }

    public void set_min_maps(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 108), n);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 112));
    }

    public void set_backing_store(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 112), n);
    }

    public boolean get_save_unders() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 116));
    }

    public void set_save_unders(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 116), bl);
    }

    public long get_root_input_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 120));
    }

    public void set_root_input_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 120), l);
    }

    String getName() {
        return "Screen";
    }

    String getFieldsAsString() {
        String string = "";
        string = string + "ext_data = " + this.get_ext_data() + ", ";
        string = string + "display = " + this.get_display() + ", ";
        string = string + "root = " + this.get_root() + ", ";
        string = string + "width = " + this.get_width() + ", ";
        string = string + "height = " + this.get_height() + ", ";
        string = string + "mwidth = " + this.get_mwidth() + ", ";
        string = string + "mheight = " + this.get_mheight() + ", ";
        string = string + "ndepths = " + this.get_ndepths() + ", ";
        string = string + "depths = " + this.get_depths() + ", ";
        string = string + "root_depth = " + this.get_root_depth() + ", ";
        string = string + "root_visual = " + this.get_root_visual() + ", ";
        string = string + "default_gc = " + this.get_default_gc() + ", ";
        string = string + "cmap = " + this.get_cmap() + ", ";
        string = string + "white_pixel = " + this.get_white_pixel() + ", ";
        string = string + "black_pixel = " + this.get_black_pixel() + ", ";
        string = string + "max_maps = " + this.get_max_maps() + ", ";
        string = string + "min_maps = " + this.get_min_maps() + ", ";
        string = string + "backing_store = " + this.get_backing_store() + ", ";
        string = string + "save_unders = " + this.get_save_unders() + ", ";
        string = string + "root_input_mask = " + this.get_root_input_mask() + ", ";
        return string;
    }
}

