/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthUI;

class SynthProgressBarUI
extends BasicProgressBarUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private int progressPadding;
    private boolean rotateText;
    private boolean paintOutsideClip;
    private boolean tileWhenIndeterminate;
    private int tileWidth;

    SynthProgressBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthProgressBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        this.updateStyle(this.progressBar);
    }

    private void updateStyle(JProgressBar jProgressBar) {
        SynthContext synthContext = this.getContext(jProgressBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        this.setCellLength(this.style.getInt(synthContext, "ProgressBar.cellLength", 1));
        this.setCellSpacing(this.style.getInt(synthContext, "ProgressBar.cellSpacing", 0));
        this.progressPadding = this.style.getInt(synthContext, "ProgressBar.progressPadding", 0);
        this.paintOutsideClip = this.style.getBoolean(synthContext, "ProgressBar.paintOutsideClip", false);
        this.rotateText = this.style.getBoolean(synthContext, "ProgressBar.rotateText", false);
        this.tileWhenIndeterminate = this.style.getBoolean(synthContext, "ProgressBar.tileWhenIndeterminate", false);
        this.tileWidth = this.style.getInt(synthContext, "ProgressBar.tileWidth", 15);
        String string = (String)this.progressBar.getClientProperty("JComponent.sizeVariant");
        if (string != null) {
            if ("large".equals(string)) {
                this.tileWidth = (int)((double)this.tileWidth * 1.15);
            } else if ("small".equals(string)) {
                this.tileWidth = (int)((double)this.tileWidth * 0.857);
            } else if ("mini".equals(string)) {
                this.tileWidth = (int)((double)this.tileWidth * 0.784);
            }
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        if (this.progressBar.isStringPainted() && this.progressBar.getOrientation() == 0) {
            SynthContext synthContext = this.getContext(jComponent);
            Font font = synthContext.getStyle().getFont(synthContext);
            FontMetrics fontMetrics = this.progressBar.getFontMetrics(font);
            synthContext.dispose();
            return (n2 - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
        }
        return -1;
    }

    protected Rectangle getBox(Rectangle rectangle) {
        if (this.tileWhenIndeterminate) {
            return SwingUtilities.calculateInnerArea(this.progressBar, rectangle);
        }
        return super.getBox(rectangle);
    }

    protected void setAnimationIndex(int n) {
        if (this.paintOutsideClip) {
            if (this.getAnimationIndex() == n) {
                return;
            }
            super.setAnimationIndex(n);
            this.progressBar.repaint();
        } else {
            super.setAnimationIndex(n);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintProgressBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), this.progressBar.getOrientation());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!jProgressBar.isIndeterminate()) {
            Insets insets = jProgressBar.getInsets();
            double d = jProgressBar.getPercentComplete();
            if (d != 0.0) {
                if (jProgressBar.getOrientation() == 0) {
                    n = insets.left + this.progressPadding;
                    n2 = insets.top + this.progressPadding;
                    n3 = (int)(d * (double)(jProgressBar.getWidth() - (insets.left + this.progressPadding + insets.right + this.progressPadding)));
                    n4 = jProgressBar.getHeight() - (insets.top + this.progressPadding + insets.bottom + this.progressPadding);
                    if (!SynthLookAndFeel.isLeftToRight(jProgressBar)) {
                        n = jProgressBar.getWidth() - insets.right - n3 - this.progressPadding;
                    }
                } else {
                    n = insets.left + this.progressPadding;
                    n3 = jProgressBar.getWidth() - (insets.left + this.progressPadding + insets.right + this.progressPadding);
                    n4 = (int)(d * (double)(jProgressBar.getHeight() - (insets.top + this.progressPadding + insets.bottom + this.progressPadding)));
                    n2 = jProgressBar.getHeight() - insets.bottom - n4 - this.progressPadding;
                }
            }
        } else {
            this.boxRect = this.getBox(this.boxRect);
            n = this.boxRect.x + this.progressPadding;
            n2 = this.boxRect.y + this.progressPadding;
            n3 = this.boxRect.width - this.progressPadding - this.progressPadding;
            n4 = this.boxRect.height - this.progressPadding - this.progressPadding;
        }
        if (this.tileWhenIndeterminate && jProgressBar.isIndeterminate()) {
            double d = (double)this.getAnimationIndex() / (double)this.getFrameCount();
            int n5 = (int)(d * (double)this.tileWidth);
            Shape shape = graphics.getClip();
            graphics.clipRect(n, n2, n3, n4);
            if (jProgressBar.getOrientation() == 0) {
                for (int i = n - this.tileWidth + n5; i <= n3; i += this.tileWidth) {
                    synthContext.getPainter().paintProgressBarForeground(synthContext, graphics, i, n2, this.tileWidth, n4, jProgressBar.getOrientation());
                }
            } else {
                for (int i = n2 - n5; i < n4 + this.tileWidth; i += this.tileWidth) {
                    synthContext.getPainter().paintProgressBarForeground(synthContext, graphics, n, i, n3, this.tileWidth, jProgressBar.getOrientation());
                }
            }
            graphics.setClip(shape);
        } else {
            synthContext.getPainter().paintProgressBarForeground(synthContext, graphics, n, n2, n3, n4, jProgressBar.getOrientation());
        }
        if (jProgressBar.isStringPainted()) {
            this.paintText(synthContext, graphics, jProgressBar.getString());
        }
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, String string) {
        if (this.progressBar.isStringPainted()) {
            SynthStyle synthStyle = synthContext.getStyle();
            Font font = synthStyle.getFont(synthContext);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.progressBar, graphics, font);
            int n = synthStyle.getGraphicsUtils(synthContext).computeStringWidth(synthContext, font, fontMetrics, string);
            Rectangle rectangle = this.progressBar.getBounds();
            if (this.rotateText && this.progressBar.getOrientation() == 1) {
                Point point;
                AffineTransform affineTransform;
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                    affineTransform = AffineTransform.getRotateInstance(-1.5707963267948966);
                    point = new Point((rectangle.width + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2, (rectangle.height + n) / 2);
                } else {
                    affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                    point = new Point((rectangle.width - fontMetrics.getAscent() + fontMetrics.getDescent()) / 2, (rectangle.height - n) / 2);
                }
                if (point.x < 0) {
                    return;
                }
                font = font.deriveFont(affineTransform);
                graphics2D.setFont(font);
                graphics2D.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, point.x, point.y, -1);
            } else {
                Rectangle rectangle2 = new Rectangle(rectangle.width / 2 - n / 2, (rectangle.height - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2, 0, 0);
                if (rectangle2.y < 0) {
                    return;
                }
                graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                graphics.setFont(font);
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle2.x, rectangle2.y, -1);
            }
        }
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4, this.progressBar.getOrientation());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent) || "indeterminate".equals(propertyChangeEvent.getPropertyName())) {
            this.updateStyle((JProgressBar)propertyChangeEvent.getSource());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        String string;
        int n;
        Dimension dimension = null;
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        String string2 = this.progressBar.getString();
        int n2 = fontMetrics.getHeight() + fontMetrics.getDescent();
        if (this.progressBar.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                if (n2 > dimension.height) {
                    dimension.height = n2;
                }
                if ((n = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string2)) > dimension.width) {
                    dimension.width = n;
                }
            }
        } else {
            dimension = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                if (n2 > dimension.width) {
                    dimension.width = n2;
                }
                if ((n = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string2)) > dimension.height) {
                    dimension.height = n;
                }
            }
        }
        if ((string = (String)this.progressBar.getClientProperty("JComponent.sizeVariant")) != null) {
            if ("large".equals(string)) {
                dimension.width = (int)((float)dimension.width * 1.15f);
                dimension.height = (int)((float)dimension.height * 1.15f);
            } else if ("small".equals(string)) {
                dimension.width = (int)((float)dimension.width * 0.9f);
                dimension.height = (int)((float)dimension.height * 0.9f);
            } else if ("mini".equals(string)) {
                dimension.width = (int)((float)dimension.width * 0.784f);
                dimension.height = (int)((float)dimension.height * 0.784f);
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

