/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLELEMENTPROPERTYCONTEXT_HXX
#define _XMLOFF_XMLELEMENTPROPERTYCONTEXT_HXX

#include <xmloff/xmlprmap.hxx>
#include <xmloff/xmlictxt.hxx>

class SvXMLImport;

namespace rtl
{
	class OUString;
}

class XMLElementPropertyContext : public SvXMLImportContext
{
	sal_Bool		bInsert;

protected:

	::std::vector< XMLPropertyState > &rProperties;
	XMLPropertyState aProp;

	sal_Bool IsInsert() const { return bInsert; }
	void SetInsert( sal_Bool bIns ) { bInsert = bIns; }

public:
	TYPEINFO();

	XMLElementPropertyContext( SvXMLImport& rImport, sal_uInt16 nPrfx,
							   const ::rtl::OUString& rLName,
							   const XMLPropertyState& rProp,
				 			   ::std::vector< XMLPropertyState > &rProps );

	virtual ~XMLElementPropertyContext();

	virtual void EndElement();
};


#endif	//  _XMLOFF_ELEMENTPROPERTYCONTEXT_HXX

