/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_ucb.hxx"
#include <com/sun/star/sdbc/XResultSet.hpp>
#ifndef _FTP_FTPDYNRESULTSET_HXX_
#include "ftpdynresultset.hxx"
#endif
#include "ftpresultsetfactory.hxx"

using namespace com::sun::star::lang;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;


using namespace ftp;

//=========================================================================
//=========================================================================
//
// DynamicResultSet Implementation.
//
//=========================================================================
//=========================================================================

DynamicResultSet::DynamicResultSet(
	const Reference< XMultiServiceFactory >& rxSMgr,
	const rtl::Reference< FTPContent >& rxContent,
	const OpenCommandArgument2& rCommand,
	const Reference< XCommandEnvironment >& rxEnv,
	ResultSetFactory* pFactory )
	: ResultSetImplHelper( rxSMgr, rCommand ),
	  m_xContent( rxContent ),
	  m_xEnv( rxEnv ),
	  m_pFactory( pFactory )
{
}

DynamicResultSet::~DynamicResultSet()
{
	delete m_pFactory;
}

//=========================================================================
//
// Non-interface methods.
//
//=========================================================================

void DynamicResultSet::initStatic()
{
	m_xResultSet1 = Reference< XResultSet >( m_pFactory->createResultSet() );
}

//=========================================================================
void DynamicResultSet::initDynamic()
{
	m_xResultSet1 = Reference< XResultSet >( m_pFactory->createResultSet() );
	
	m_xResultSet2 = m_xResultSet1;
}




