/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/primitive3d/shadowprimitive3d.hxx>
#include <drawinglayer/primitive3d/drawinglayer_primitivetypes3d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace primitive3d
	{
		ShadowPrimitive3D::ShadowPrimitive3D(
			const basegfx::B2DHomMatrix& rShadowTransform, 
			const basegfx::BColor& rShadowColor, 
			double fShadowTransparence, 
			bool bShadow3D, 
			const Primitive3DSequence& rChildren)
		:	GroupPrimitive3D(rChildren),
			maShadowTransform(rShadowTransform),
			maShadowColor(rShadowColor),
			mfShadowTransparence(fShadowTransparence),
			mbShadow3D(bShadow3D)
		{
		}

		bool ShadowPrimitive3D::operator==(const BasePrimitive3D& rPrimitive) const
		{
			if(GroupPrimitive3D::operator==(rPrimitive))
			{
				const ShadowPrimitive3D& rCompare = (ShadowPrimitive3D&)rPrimitive;

				return (getShadowTransform() == rCompare.getShadowTransform()
					&& getShadowColor() == rCompare.getShadowColor()
					&& getShadowTransparence() == rCompare.getShadowTransparence()
					&& getShadow3D() == rCompare.getShadow3D());
			}

			return false;
		}

		// provide unique ID
		ImplPrimitrive3DIDBlock(ShadowPrimitive3D, PRIMITIVE3D_ID_SHADOWPRIMITIVE3D)

	} // end of namespace primitive3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
