/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import sun.misc.Unsafe;

public final class AWTAccessor {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static WindowAccessor windowAccessor;
    private static ComponentAccessor componentAccessor;
    private static AWTEventAccessor awtEventAccessor;

    private AWTAccessor() {
    }

    public static void setWindowAccessor(WindowAccessor windowAccessor) {
        AWTAccessor.windowAccessor = windowAccessor;
    }

    public static WindowAccessor getWindowAccessor() {
        if (windowAccessor == null) {
            unsafe.ensureClassInitialized(Window.class);
        }
        return windowAccessor;
    }

    public static void setComponentAccessor(ComponentAccessor componentAccessor) {
        AWTAccessor.componentAccessor = componentAccessor;
    }

    public static ComponentAccessor getComponentAccessor() {
        if (componentAccessor == null) {
            unsafe.ensureClassInitialized(Component.class);
        }
        return componentAccessor;
    }

    public static void setAWTEventAccessor(AWTEventAccessor aWTEventAccessor) {
        awtEventAccessor = aWTEventAccessor;
    }

    public static AWTEventAccessor getAWTEventAccessor() {
        return awtEventAccessor;
    }

    public static interface AWTEventAccessor {
        public void setSystemGenerated(AWTEvent var1);

        public boolean isSystemGenerated(AWTEvent var1);
    }

    public static interface ComponentAccessor {
        public void setBackgroundEraseDisabled(Component var1, boolean var2);

        public boolean getBackgroundEraseDisabled(Component var1);

        public void setOpaqueForMixing(Component var1, boolean var2);

        public Rectangle getBounds(Component var1);
    }

    public static interface WindowAccessor {
        public float getOpacity(Window var1);

        public void setOpacity(Window var1, float var2);

        public Shape getShape(Window var1);

        public void setShape(Window var1, Shape var2);

        public boolean isOpaque(Window var1);

        public void setOpaque(Window var1, boolean var2);

        public void updateWindow(Window var1, BufferedImage var2);

        public Dimension getSecurityWarningSize(Window var1);

        public void setSecurityWarningPosition(Window var1, Point2D var2, float var3, float var4);

        public Point2D calculateSecurityWarningPosition(Window var1, double var2, double var4, double var6, double var8);
    }
}

