#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2008 by Sun Microsystems, Inc.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# $RCSfile: exiter.pm,v $
#
# $Revision: 1.4 $
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************


package packager::exiter;

use packager::files;
use packager::globals;

############################################
# Exiting the program with an error
# This function is used instead of "die"
############################################

sub exit_program
{
	my ($message, $function) = @_;
	
	my $infoline;

	$infoline = "\n***************************************************************\n";
	push(@packager::globals::logfileinfo, $infoline);
	print("$infoline");
	
	$infoline = "$message\n";
	push(@packager::globals::logfileinfo, $infoline);
	print("$infoline");

	$infoline = "in function: $function\n";
	push(@packager::globals::logfileinfo, $infoline);
	print("$infoline");

	$infoline = "***************************************************************\n";
	push(@packager::globals::logfileinfo, $infoline);

	packager::files::save_file($packager::globals::logfilename ,\@packager::globals::logfileinfo);

	print("Saved logfile: $packager::globals::logfilename\n");
	print("$infoline");
		
	exit(-1);	
}

1;