/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: SlsHighlightObject.hxx,v $
 *
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef SD_SLIDESORTER_VIEW_HIGHLIGHT_OBJECT_HXX
#define SD_SLIDESORTER_VIEW_HIGHLIGHT_OBJECT_HXX

#include "SlideSorter.hxx"
#include "model/SlsSharedPageDescriptor.hxx"
#include <svx/svdobj.hxx>
#include <svx/sdr/contact/viewcontactofsdrobj.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>

namespace sd { namespace slidesorter { namespace view {


/** A shape typically used for highlighting the current slide.
*/
class HighlightObject
    : public SdrObject
{
public:
	HighlightObject (SlideSorter& rSlideSorter);
    virtual ~HighlightObject (void);

    /** Set the slide that is to be highlighted.
    */
    void SetSlide (const model::SharedPageDescriptor& rpDescriptor);

    /** Return the slide to highlight.
    */
    model::SharedPageDescriptor GetSlide (void) const;

    void SetOpacity (const double nOpacity);

    double GetOpacity (void) const;

    /** Set the bounding box to the given rectangle.  This method is
        typically called only by an animator.

        For getting the bounding box, call GetCurrentBoundRect.
    */
    void SetBoundingBox (const Rectangle& rBox);

    /** Return the current bounding box.
    */
	virtual const Rectangle& GetCurrentBoundRect (void) const;

    void UpdatePosition (void);

private:
    model::SharedPageDescriptor mpDescriptor;
	SlideSorter& mrSlideSorter;
    Rectangle maBoundingBox;
    double mnOpacity;

    virtual sdr::contact::ViewContact* CreateObjectSpecificViewContact (void);
};




/** The ViewContact of the HighlightObject class.  Used primarily as factory
    for ViewObjectContact objects.
*/
class HighlightViewContact
    : public ::sdr::contact::ViewContactOfSdrObj
{
public:
    HighlightViewContact (HighlightObject& rHighlightObject);
    virtual ~HighlightViewContact (void);

    virtual ::sdr::contact::ViewObjectContact& 
        CreateObjectSpecificViewObjectContact(
            ::sdr::contact::ObjectContact& rObjectContact);

    virtual void ActionChanged (void);

protected:
    virtual void PrepareDelete (void);
    virtual void CalcPaintRectangle (void);
    
private:
    HighlightObject& mrHighlightObject;
};




/** The ViewObjectContact of the HighlightObject class that does the actual
    painting.
*/
class HighlightViewObjectContact
    : public ::sdr::contact::ViewObjectContact
{
public:
    HighlightViewObjectContact (
        ::sdr::contact::ObjectContact& rObjectContact, 
            ::sdr::contact::ViewContact& rViewContact,
        HighlightObject* pHighlightObject);
    virtual ~HighlightViewObjectContact (void);

    virtual void PaintObject (::sdr::contact::DisplayInfo& rDisplayInfo);

    virtual void PrepareDelete (void);

private:
    HighlightObject* mpHighlightObject;
};


} } } // end of namespace ::sd::slidesorter::view

#endif
