/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: transfrm.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: obo $ $Date: 2007/07/18 10:53:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_TRANSFRM_HXX
#define _SVX_TRANSFRM_HXX

// include ---------------------------------------------------------------

#include <svx/dlgctrl.hxx>

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

// #i75273#
#ifndef _BGFX_RANGE_B2DRANGE_HXX
#include <basegfx/range/b2drange.hxx>
#endif

// predefines
class SdrView;

/*************************************************************************
|*
|* Transform-Tab-Dialog
|*
\************************************************************************/

/** put this into the nAnchorTypes parameter of the SvxTransformTabDialog c'tor
	to disable the size controls */
const USHORT SVX_OBJ_NORESIZE = 0x0100;

/** put this into the nAnchorTypes parameter of the SvxTransformTabDialog c'tor
	to disable the protect controls */
const USHORT SVX_OBJ_NOPROTECT = 0x0200;

class SvxTransformTabDialog : public SfxTabDialog
{
private:
	const SdrView*		pView;

	USHORT				nAnchorCtrls;
    Link                aValidateLink;

	virtual void		PageCreated( USHORT nId, SfxTabPage &rPage );

public:

			SvxTransformTabDialog( Window* pParent, const SfxItemSet* pAttr,
							const SdrView* pView,
							USHORT nAnchorTypes = 0);
			~SvxTransformTabDialog();
            
            //link for the Writer to validate positions 
            void SetValidateFramePosLink( const Link& rLink );
};

/*************************************************************************
|*
|* position and size tab page
|*
\************************************************************************/

class SvxPositionSizeTabPage : public SvxTabPage
{
	using TabPage::ActivatePage;
	using TabPage::DeactivatePage;

private:
	// position
	FixedLine			maFlPosition;
	FixedText			maFtPosX;
	MetricField			maMtrPosX;
	FixedText			maFtPosY;
	MetricField			maMtrPosY;
	FixedText			maFtPosReference;
	SvxRectCtl			maCtlPos;

	// size
	FixedLine			maFlSize;
	FixedText			maFtWidth;
	MetricField			maMtrWidth;
	FixedText			maFtHeight;
	MetricField			maMtrHeight;
	CheckBox   			maCbxScale;
	FixedText			maFtSizeReference;
	SvxRectCtl			maCtlSize;

	// protect
	FixedLine			maFlProtect;
	TriStateBox			maTsbPosProtect;
	TriStateBox			maTsbSizeProtect;

	// adjust
	FixedLine			maFlAdjust;
	TriStateBox         maTsbAutoGrowWidth;
	TriStateBox         maTsbAutoGrowHeight;

	FixedLine			maFlDivider;

private:
	const SfxItemSet&	mrOutAttrs;

	const SdrView*		mpView;

	// #i75273#
	basegfx::B2DRange	maRange;
	basegfx::B2DRange	maWorkRange;
	basegfx::B2DPoint	maAnchor;

	SfxMapUnit			mePoolUnit;
	FieldUnit			meDlgUnit;
	MapUnit				meMapUnit;
    TriState			mnProtectSizeState;
	bool				mbPageDisabled;
	bool				mbProtectDisabled;
	bool				mbSizeDisabled;

	// frome size
	// #i75273#
	double				mfOldWidth;
	double				mfOldHeight;
	RECT_POINT			meRP;

	//------------------------------------
#if _SOLAR__PRIVATE
	DECL_LINK( ChangePosProtectHdl, void * );
	DECL_LINK( ChangeSizeProtectHdl, void * );
	DECL_LINK( ChangePosXHdl, void * );
	DECL_LINK( ChangePosYHdl, void * );
//  DECL_LINK( SetAnchorHdl, ListBox * );
//  DECL_LINK( SetOrientHdl, ListBox * );

	void SetMinMaxPosition();
	void GetTopLeftPosition(double& rfX, double& rfY, const basegfx::B2DRange& rRange);
#endif

#if _SOLAR__PRIVATE
	DECL_LINK( ChangeWidthHdl, void * );
	DECL_LINK( ChangeHeightHdl, void * );
	DECL_LINK( ClickSizeProtectHdl, void * );
	DECL_LINK( ClickAutoHdl, void * );

	void		SetMaxSize( Rectangle aRect );
	Rectangle	GetRect();
#endif

public:
	SvxPositionSizeTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { mpView = pSdrView; }

//  void         ShowAnchorCtrls(USHORT nAnchorCtrls); // Writer-spezifische Controls anzeigen
	virtual void FillUserData();

	void		DisableResize();
	void		DisableProtect();

    void 		UpdateControlStates();
};

/*************************************************************************
|*
|* Drehwinkel-Tab-Page
|*
\************************************************************************/
class SvxAngleTabPage : public SvxTabPage
{
	using TabPage::ActivatePage;
	using TabPage::DeactivatePage;

private:
	FixedLine			aFlPosition;
	FixedText			aFtPosX;
	MetricField			aMtrPosX;
	FixedText			aFtPosY;
	MetricField			aMtrPosY;
	FixedText			aFtPosPresets;
	SvxRectCtl			aCtlRect;

	FixedLine			aFlAngle;
	FixedText			aFtAngle;
	MetricField			aMtrAngle;
	FixedText			aFtAnglePresets;
	SvxRectCtl			aCtlAngle;

	const SfxItemSet&	rOutAttrs;
	const SdrView*		pView;

	// #i75273#
	basegfx::B2DRange	maRange;
	basegfx::B2DPoint	maAnchor;

	SfxMapUnit			ePoolUnit;
	FieldUnit			eDlgUnit;
	MapUnit				eMapUnit;
	//------------------------------------
#if _SOLAR__PRIVATE
	DECL_LINK( ModifiedHdl, void * );
#endif
public:
		 SvxAngleTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { pView = pSdrView; }
};

/*************************************************************************
|*
|* Schraegstellen/Eckenradius-Tab-Page
|*
\************************************************************************/
class SvxSlantTabPage : public SvxTabPage
{
	using TabPage::ActivatePage;
	using TabPage::DeactivatePage;

private:
	FixedLine			aFlRadius;
	FixedText			aFtRadius;
	MetricField			aMtrRadius;
	//TriStateBox			aTsbVertical;
	FixedLine			aFlAngle;
	FixedText			aFtAngle;
	MetricField			aMtrAngle;
	//SvxRectCtl			aCtlAngle;

	const SfxItemSet&	rOutAttrs;

	const SdrView*		pView;

	// #i75273#
	basegfx::B2DRange	maRange;

	SfxMapUnit			ePoolUnit;
	FieldUnit			eDlgUnit;
	MapUnit				eMapUnit;
	//------------------------------------
public:
		 SvxSlantTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { pView = pSdrView; }
};



#endif // _SVX_TRANSFRM_HXX

