/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AcceptLicenseCtrl.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/03 11:50:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package org.openoffice.setup.Controller;

import org.openoffice.setup.PanelController;
import org.openoffice.setup.Panel.AcceptLicense;
import org.openoffice.setup.ResourceManager;

public class AcceptLicenseCtrl extends PanelController {

    private String helpFile;

    public AcceptLicenseCtrl() {
        super("AcceptLicense", new AcceptLicense());
        helpFile = "String_Helpfile_AcceptLicense";
    }
    
    public String getNext() {
        return new String("ChooseDirectory");
    }
    
    public String getPrevious() {
        return new String("Prologue");
    }  

    public final String getHelpFileName () {
        return this.helpFile;
    }
 
    public void beforeShow() {
        String StringInstall = ResourceManager.getString("String_AcceptLicense");
        getSetupFrame().setButtonText(StringInstall, getSetupFrame().BUTTON_NEXT);
        String StringDecline = ResourceManager.getString("String_Decline");
        getSetupFrame().setButtonText(StringDecline, getSetupFrame().BUTTON_CANCEL);

        getSetupFrame().setButtonSelected(getSetupFrame().BUTTON_CANCEL);
    }
    
}
