/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.xml.internal.stream.StaxEntityResolverWrapper;
import java.util.HashMap;
import javax.xml.stream.XMLResolver;

public class PropertyManager {
    protected static final String STAX_NOTATIONS = "javax.xml.stream.notations";
    protected static final String STAX_ENTITIES = "javax.xml.stream.entities";
    private static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    HashMap supportedProps = new HashMap();
    public static final int CONTEXT_READER = 1;
    public static final int CONTEXT_WRITER = 2;

    public PropertyManager(int n) {
        switch (n) {
            case 1: {
                this.initConfigurableReaderProperties();
                break;
            }
            case 2: {
                this.initWriterProps();
            }
        }
    }

    public PropertyManager(PropertyManager propertyManager) {
        HashMap hashMap = propertyManager.getProperties();
        this.supportedProps.putAll(hashMap);
    }

    private HashMap getProperties() {
        return this.supportedProps;
    }

    private void initConfigurableReaderProperties() {
        this.supportedProps.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isValidating", Boolean.FALSE);
        this.supportedProps.put("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.supportedProps.put("javax.xml.stream.supportDTD", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.reporter", null);
        this.supportedProps.put("javax.xml.stream.resolver", null);
        this.supportedProps.put("javax.xml.stream.allocator", null);
        this.supportedProps.put(STAX_NOTATIONS, null);
        this.supportedProps.put(STRING_INTERNING, new Boolean(true));
        this.supportedProps.put("http://apache.org/xml/features/allow-java-encodings", new Boolean(true));
        this.supportedProps.put("add-namespacedecl-as-attrbiute", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/reader-in-defined-state", new Boolean(true));
        this.supportedProps.put("reuse-instance", new Boolean(true));
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/report-cdata-event", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/warn-on-duplicate-entitydef", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", new Boolean(false));
    }

    private void initWriterProps() {
        this.supportedProps.put("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        this.supportedProps.put("escapeCharacters", Boolean.TRUE);
        this.supportedProps.put("reuse-instance", new Boolean(true));
    }

    public boolean containsProperty(String string) {
        return this.supportedProps.containsKey(string);
    }

    public Object getProperty(String string) {
        return this.supportedProps.get(string);
    }

    public void setProperty(String string, Object object) {
        String string2 = null;
        if (string == "javax.xml.stream.isNamespaceAware" || string.equals("javax.xml.stream.isNamespaceAware")) {
            string2 = "http://apache.org/xml/features/namespaces";
        } else if (string == "javax.xml.stream.isValidating" || string.equals("javax.xml.stream.isValidating")) {
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                throw new IllegalArgumentException("true value of isValidating not supported");
            }
        } else if (string == STRING_INTERNING || string.equals(STRING_INTERNING)) {
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                throw new IllegalArgumentException("false value of http://xml.org/sax/features/string-interningfeature is not supported");
            }
        } else if (string == "javax.xml.stream.resolver" || string.equals("javax.xml.stream.resolver")) {
            this.supportedProps.put("http://apache.org/xml/properties/internal/stax-entity-resolver", new StaxEntityResolverWrapper((XMLResolver)object));
        }
        this.supportedProps.put(string, object);
        if (string2 != null) {
            this.supportedProps.put(string2, object);
        }
    }

    public String toString() {
        return this.supportedProps.toString();
    }
}

