/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.jnlp.JNLPRandomAccessFileImpl;
import com.sun.jnlp.MeteredFileOutputStream;
import com.sun.jnlp.PersistenceServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class FileContentsImpl
implements FileContents {
    private String _name = null;
    private File _file = null;
    private long _limit = Long.MAX_VALUE;
    private URL _url = null;
    private JNLPRandomAccessFile _raf = null;
    private PersistenceServiceImpl _psCallback = null;

    FileContentsImpl(File file, long l) throws IOException {
        this._file = file;
        this._limit = l;
        this._name = this._file.getName();
    }

    FileContentsImpl(File file, PersistenceServiceImpl persistenceServiceImpl, URL uRL, long l) {
        this._file = file;
        this._url = uRL;
        this._psCallback = persistenceServiceImpl;
        this._limit = l;
        int n = uRL.getFile().lastIndexOf(47);
        this._name = n != -1 ? uRL.getFile().substring(n + 1) : uRL.getFile();
    }

    public String getName() {
        return this._name;
    }

    public long getLength() {
        Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(FileContentsImpl.this._file.length());
            }
        });
        return l;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileInputStream(FileContentsImpl.this._file);
                }
            });
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    public OutputStream getOutputStream(final boolean bl) throws IOException {
        try {
            OutputStream outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new MeteredFileOutputStream(FileContentsImpl.this._file, !bl, FileContentsImpl.this);
                }
            });
            return outputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    public boolean canRead() throws IOException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(FileContentsImpl.this._file.canRead());
            }
        });
        return bl;
    }

    public boolean canWrite() throws IOException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(FileContentsImpl.this._file.canWrite());
            }
        });
        return bl;
    }

    public JNLPRandomAccessFile getRandomAccessFile(final String string) throws IOException {
        try {
            return (JNLPRandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException, IOException {
                    return new JNLPRandomAccessFileImpl(FileContentsImpl.this._file, string, FileContentsImpl.this);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    public long getMaxLength() throws IOException {
        return this._limit;
    }

    public long setMaxLength(long l) throws IOException {
        if (this._psCallback != null) {
            this._limit = this._psCallback.setMaxLength(this._url, l);
            return this._limit;
        }
        this._limit = l;
        return this._limit;
    }

    private IOException rethrowException(PrivilegedActionException privilegedActionException) throws IOException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new IOException(exception.getMessage());
    }
}

