/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NamespaceMapper.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/02/26 15:35:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <iostream>
#include <rtl/ustring.hxx>
#include "NamespaceMapper.hxx"

namespace ooxml
{
using namespace ::std;

NamespaceMapper::NamespaceMapper()
{
}

NamespaceMapper::~NamespaceMapper()
{
}

void NamespaceMapper::addMapping(const rtl::OUString & rPrefix,
                                 const rtl::OUString & rUrl)
{
#ifdef DEBUG_NAMESPACEMAPPER
    clog << "NamespaceMapper::addMapping: " 
         << OUStringToOString(rPrefix, RTL_TEXTENCODING_ASCII_US).getStr()
         << "->" 
         << OUStringToOString(rUrl, RTL_TEXTENCODING_ASCII_US).getStr()
         << endl;
#endif
    mMap[rPrefix] = rUrl;
}

TokenEnum_t NamespaceMapper::getToken(TokenMap::TokenType_t nType,
                                      const rtl::OUString & rTokenString)
{
    sal_Int32 nIndex = rTokenString.indexOf(':');
    rtl::OUString sNamespace;
    rtl::OUString sMember;

#ifdef DEBUG_NAMESPACEMAPPER
    dump();
#endif

    if (nIndex > 0)
    {
        sNamespace = rTokenString.copy(0, nIndex);
        sMember = rTokenString.copy(nIndex + 1);
    }
    else
        sMember = rTokenString;

    rtl::OUString sTokenStringMapped = mMap[sNamespace];
    if (sTokenStringMapped.getLength() == 0)
        sTokenStringMapped = sNamespace;

    sTokenStringMapped += rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(":"));
    sTokenStringMapped += sMember;

#ifdef DEBUG_NAMESPACEMAPPER
    clog << "NamespaceMapper::getToken: " 
         << OUStringToOString(sTokenStringMapped, 
                              RTL_TEXTENCODING_ASCII_US).getStr()
         << endl;
#endif

    TokenEnum_t nResult = TokenMap::getInstance()->
        getToken(nType, sTokenStringMapped);
    
    return nResult;
}

#ifdef DEBUG_NAMESPACEMAPPER
void NamespaceMapper::dump()
{
    Map_t::iterator aIt = mMap.begin();
    
    clog << "[" << endl;

    while (aIt != mMap.end())
    {
        clog << OUStringToOString(aIt->first, 
                                  RTL_TEXTENCODING_ASCII_US).getStr()
             << "->" 
             << OUStringToOString(aIt->second, 
                                  RTL_TEXTENCODING_ASCII_US).getStr()
             << endl;

        aIt++;
    }

    clog << "]" << endl;
}
#endif

}
