/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalMarkerAxisBand;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.IntervalMarker;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Window;

public class HorizontalBarChartDemo
extends ApplicationFrame {
    public HorizontalBarChartDemo(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{1.0, 43.0, 35.0, 58.0, 54.0, 77.0, 71.0, 89.0}, {54.0, 75.0, 63.0, 83.0, 43.0, 46.0, 27.0, 13.0}, {41.0, 33.0, 22.0, 34.0, 62.0, 32.0, 42.0, 34.0}};
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset(dArrayArray);
        defaultCategoryDataset.setSeriesName(0, "First");
        defaultCategoryDataset.setSeriesName(1, "Second");
        defaultCategoryDataset.setSeriesName(2, "Third");
        Object[] objectArray = new String[]{"Factor 1", "Factor 2", "Factor 3", "Factor 4", "Factor 5", "Factor 6", "Factor 7", "Factor 8"};
        defaultCategoryDataset.setCategories(objectArray);
        JFreeChart jFreeChart = ChartFactory.createHorizontalBarChart("Horizontal Bar Chart", "Category", "Score (%)", defaultCategoryDataset, true);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setSeriesPaint(new Paint[]{new Color(0, 0, 255), new Color(75, 75, 255), new Color(150, 150, 255)});
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setRange(0.0, 100.0);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        HorizontalNumberAxis horizontalNumberAxis = (HorizontalNumberAxis)numberAxis;
        HorizontalMarkerAxisBand horizontalMarkerAxisBand = new HorizontalMarkerAxisBand(horizontalNumberAxis, 2.0, 2.0, 2.0, 2.0, new Font("SansSerif", 0, 9));
        IntervalMarker intervalMarker = new IntervalMarker(0.0, 33.0, "Low", Color.gray, new BasicStroke(0.5f), Color.green, 0.75f);
        IntervalMarker intervalMarker2 = new IntervalMarker(33.0, 66.0, "Medium", Color.gray, new BasicStroke(0.5f), Color.orange, 0.75f);
        IntervalMarker intervalMarker3 = new IntervalMarker(66.0, 100.0, "High", Color.gray, new BasicStroke(0.5f), Color.red, 0.75f);
        horizontalMarkerAxisBand.addMarker(intervalMarker);
        horizontalMarkerAxisBand.addMarker(intervalMarker2);
        horizontalMarkerAxisBand.addMarker(intervalMarker3);
        horizontalNumberAxis.setMarkerBand(horizontalMarkerAxisBand);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        HorizontalBarChartDemo horizontalBarChartDemo = new HorizontalBarChartDemo("Horizontal Bar Chart Demo");
        horizontalBarChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)horizontalBarChartDemo));
        horizontalBarChartDemo.setVisible(true);
    }
}

