/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractCategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private boolean plotShapes;
    private boolean plotLines;
    private double shapeScale = 6.0;
    private int labelPosition;

    public LineAndShapeRenderer() {
        this(3, 1);
    }

    public LineAndShapeRenderer(int n) {
        this(n, 1);
    }

    public LineAndShapeRenderer(int n, int n2) {
        this(n, n2, null, null);
    }

    public LineAndShapeRenderer(int n, int n2, CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        this.labelPosition = n2;
    }

    public Rectangle2D getAxisArea(Rectangle2D rectangle2D) {
        return rectangle2D;
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            Object object3;
            Object object4;
            double d = categoryPlot.getCategoryCoordinate(n2, rectangle2D);
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            graphics2D.setPaint(categoryPlot.getSeriesPaint(n));
            graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
            Shape shape = null;
            if (this.plotShapes) {
                shape = categoryPlot.getShape(n, object, d, d2, this.shapeScale);
                graphics2D.fill(shape);
            } else {
                shape = new Rectangle2D.Double(d - 2.0, d2 - 2.0, 4.0, 4.0);
            }
            if (this.plotLines && object2 != null && (object4 = categoryDataset.getValue(n, object2)) != null) {
                double d3 = ((Number)object4).doubleValue();
                double d4 = categoryPlot.getCategoryCoordinate(n2 - 1, rectangle2D);
                double d5 = valueAxis.translateValueToJava2D(d3, rectangle2D);
                graphics2D.setPaint(categoryPlot.getSeriesPaint(n));
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                Line2D.Double double_ = new Line2D.Double(d4, d5, d, d2);
                graphics2D.draw(double_);
            }
            if (categoryPlot.getLabelsVisible()) {
                object4 = categoryPlot.getLabelFormatter();
                Font font = categoryPlot.getLabelFont();
                graphics2D.setFont(font);
                object3 = categoryPlot.getLabelPaint();
                graphics2D.setPaint((Paint)object3);
                boolean bl = categoryPlot.getVerticalLabels();
                String string = ((Format)object4).format(number);
                this.drawLabel(graphics2D, string, d, d2, font, bl);
            }
            if (this.getInfo() != null && (object4 = this.getInfo().getEntityCollection()) != null && shape != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
                }
                object3 = null;
                if (this.getURLGenerator() != null) {
                    object3 = this.getURLGenerator().generateURL(categoryDataset, n, object);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, (String)object3, n, object, n2);
                object4.addEntity(categoryItemEntity);
            }
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, double d, double d2, Font font, boolean bl) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = lineMetrics.getLeading();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        int n = this.labelPosition;
        if (bl) {
            float f2;
            float f3;
            if (n == 1) {
                f3 = (float)(d + d4 / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(d2 - this.shapeScale);
            } else if (n == 2) {
                f3 = (float)(d + d4 / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(d2 + this.shapeScale + d3);
            } else if (n == 3) {
                f3 = (float)(d - this.shapeScale / 2.0 - (double)f - (double)lineMetrics.getDescent());
                f2 = (float)(d2 + d3 / 2.0);
            } else {
                f3 = (float)(d + this.shapeScale / 2.0 + (double)f + (double)lineMetrics.getAscent());
                f2 = (float)(d2 + d3 / 2.0);
            }
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)f3, (float)f2, (double)-1.5707963267948966);
        } else {
            float f4;
            float f5;
            if (n == 1) {
                f5 = (float)(d - d3 / 2.0);
                f4 = (float)(d2 - this.shapeScale / 2.0 - (double)lineMetrics.getDescent() - (double)f);
            } else if (n == 2) {
                f5 = (float)(d - d3 / 2.0);
                f4 = (float)(d2 + this.shapeScale / 2.0 + (double)lineMetrics.getAscent() + (double)f);
            } else if (n == 3) {
                f5 = (float)(d - this.shapeScale - d3);
                f4 = (float)(d2 + d4 / 2.0 - (double)lineMetrics.getDescent());
            } else {
                f5 = (float)(d + this.shapeScale);
                f4 = (float)(d2 + d4 / 2.0 - (double)lineMetrics.getDescent());
            }
            graphics2D.drawString(string, f5, f4);
        }
    }
}

