#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: ihi $ $Date: 2007/06/05 11:51:39 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..
TARGET=osxbundle

# --- Settings -------------------------------------------------

.INCLUDE :	settings.mk

# --- Files ----------------------------------------------------

.IF "$(OS)"!="MACOSX"

dummy:
        @echo "Nothing to build for OS $(OS)"

.ELSE           # "$(OS)"!="MACOSX"

BUNDLE = $(MISC)$/OpenOffice.org.app
CONTENTS = $(BUNDLE)$/Contents
VERSIONED = $(MISC)$/versioned

scriptfiles = \
	$(CONTENTS)$/Resources$/Scripts$/main.scpt	\
	$(CONTENTS)$/Resources$/Scripts$/PostInstall.scpt

plistfiles  = $(CONTENTS)$/Info.plist 

ZIPFLAGS = -r
ZIP1TARGET = osxbundle
ZIP1DIR = $(CONTENTS)
ZIP1LIST = *

.IF "$(GUIBASE)"!="aqua"
CREATOR_TYPE=OOo2
BUNDLEEXECUTABLE=droplet
.ELSE
CREATOR_TYPE=OOO2
BUNDLEEXECUTABLE=soffice.bin
.ENDIF

# --- Targets --------------------------------------------------

.INCLUDE : target.mk

$(ZIP1TARGETN) : $(scriptfiles) $(plistfiles)

$(plistfiles) : $(scriptfiles)

# create application bundle from apple script source
# Info.plist will be deleted to trigger copy rule of our own Info.plist  
$(CONTENTS)$/Resources$/Scripts$/main.scpt : application/main.applescript
	$(RM) -r $(BUNDLE)
	make_versioned.sh "$<" "$(VERSIONED)/$<"
	osacompile -o $(BUNDLE) -c $(CREATOR_TYPE) -s "$(VERSIONED)/$<"
	echo "APPL$(CREATOR_TYPE)" > $(CONTENTS)$/PkgInfo
	$(RM) "$(CONTENTS)$/Info.plist" "$(VERSIONED)/$<"

$(CONTENTS)$/Resources$/Scripts$/%.scpt : application/%.applescript
	make_versioned.sh "$<" "$(VERSIONED)/$<"
	osacompile -d -o "$@" "$(VERSIONED)/$<"
	$(RM) "$(VERSIONED)/$<"

# Info.plist is just versioned and copied into the bundle	
$(CONTENTS)$/%.plist : application/%.plist
	make_versioned.sh "$<" "$(VERSIONED)/$<"
        sed "s|\%BUNDLEEXECUTABLE|${BUNDLEEXECUTABLE}|g" "$(VERSIONED)/$<" > "$@"

# The InfoPlist.strings file has to be in UTF-16, thus a back-and-forth conversion
# is needed for versioning
#
# THIS CODE IS PRESERVED FOR FUTURE LOCALIZATION EFFORTS
#$(CONTENTS)$/Resources$/InfoPlist.strings : application/InfoPlist.strings	
#	iconv -f UTF-16 -t UTF-8 "$<" > "$(VERSIONED)/tmp.utf8"
#	make_versioned.sh "$(VERSIONED)/tmp.utf8" "$(VERSIONED)/$<"
#	iconv -f UTF-8 -t UTF-16 "$(VERSIONED)/$<" > "$@"
#	$(RM) "$(VERSIONED)/tmp.utf8" "$(VERSIONED)/$<"
	
.ENDIF		# "$(OS)"!="MACOSX"

