/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://jfreereport.pentaho.org/libfonts/
 *
 * (C) Copyright 2006, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: FontType.java,v 1.5 2007/05/13 12:44:09 taqua Exp $
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */
package org.jfree.fonts.registry;

/**
 * Creation-Date: 16.12.2005, 19:51:49
 *
 * @author Thomas Morgner
 */
public class FontType
{
  public static final FontType OPENTYPE = new FontType("OPENTYPE");
  public static final FontType AWT = new FontType("AWT");
  public static final FontType MONOSPACE = new FontType("MONOSPACE");

  private final String myName; // for debug only

  /**
   * We intentionally allow others to derive other font types.
   * @param name the name.
   */
  protected FontType(String name)
  {
    myName = name;
  }

  public String toString()
  {
    return myName;
  }
}
