/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: data.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:35:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/data.hxx>


// NOT FULLY DEFINED SERVICES



namespace udm
{

//**************************        Data_Null       *********************//

namespace
{

class Data_Null : public ::udm::Data
{                                                   
  public:
                        Data_Null();
                        ~Data_Null();

  private:
    // Interface Data:
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    virtual accessor_type
                        inq_Type() const;
    virtual description inq_TypeDescription() const;
};

Data_Null::Data_Null()
    :   Data( csv::Type2Type<bool>() )  // This sets refcount to 1, so this
                                        //   instance is never deleted or freed.
{
}

Data_Null::~Data_Null()
{
}

void
Data_Null::do_Dispose()
{
 	// Does nothing - Data_Null lives until the end of the program.
}

void
Data_Null::do_BinWrite( csv::bostream & ) const
{
    // Does nothing.
}

Data::accessor_type
Data_Null::inq_Type() const
{
 	return t_None;
}

Data::description
Data_Null::inq_TypeDescription() const
{
    return "";
}

}   // anonymous namespace



//**************************        Data       *********************//

Data &
Data::null_()
{
    // Looks like a memory leak, but isn't.
    //   Memory will be removed by program completion.
    static Data * pNull_ = new Data_Null;
    return *pNull_;
}

Stdstr &
Data::access_Str()
    { return get_null( csv::Type2Type<Stdstr>() ); }
Integer &
Data::access_Int()
    { return get_null( csv::Type2Type<Integer>() ); }
UInteger &
Data::access_Uint()
    { return get_null( csv::Type2Type<UInteger>() ); }
Real &
Data::access_Real()
    { return get_null( csv::Type2Type<Real>() ); }
Boolean &
Data::access_Bool()
    { return get_null( csv::Type2Type<Boolean>() ); }
BinaryStream &
Data::access_Bstream()
    { return get_null( csv::Type2Type<BinaryStream>() ); }
Enum &
Data::access_Enum()
    { return get_null( csv::Type2Type<Enum>() ); }
Ptr &
Data::access_Ptr()
    { return get_null( csv::Type2Type<Ptr>() ); }
Dynamic &
Data::access_Dyn()
    { return get_null( csv::Type2Type<Dynamic>() ); }
Array &
Data::access_Array()
    { return get_null( csv::Type2Type<Array>() ); }
Map &
Data::access_Map()
    { return get_null( csv::Type2Type<Map>() ); }
Struct &
Data::access_Struct()
    { return get_null( csv::Type2Type<Struct>() ); }


}   // namespace udm

