/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: linkdlg.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2007/04/11 12:25:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _LINKDLG_HXX
#define _LINKDLG_HXX

#ifndef _SO2REF_HXX
#include <so3/so2ref.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef INCLUDED_SO3DLLAPI_H
#include "so3/so3dllapi.h"
#endif

class SvTabListBox;
class Window;
class RadioButton;
class PushButton;
class Window;

namespace so3 {

/********************** SvUpdateLinksDialog ******************************
*************************************************************************/
class SvBaseLinksDlg;
class SvLinkManager;
class SvBaseLink;

class SO3_DLLPUBLIC SvBaseLinksDialog
{
private:
	SvBaseLinksDlg* pDlg;
	SvLinkManager*	pLinkMgr;
	BOOL 			bHtmlMode;
//#if 0 // _SOLAR__PRIVATE
	DECL_LINK( LinksSelectHdl, SvTabListBox * );
	DECL_LINK( LinksDoubleClickHdl, SvTabListBox * );
	DECL_LINK( AutomaticClickHdl, RadioButton * );
	DECL_LINK( ManualClickHdl, RadioButton * );
	DECL_LINK( UpdateNowClickHdl, PushButton * );
	DECL_LINK( OpenSourceClickHdl, PushButton * );
	DECL_LINK( ChangeSourceClickHdl, PushButton * );
	DECL_LINK( BreakLinkClickHdl, PushButton * );
	DECL_LINK( UpdateWaitingHdl, Timer * );
	SvBaseLink* GetSelEntry( USHORT* pPos );
	String ImplGetStateStr( const SvBaseLink& );
	void SetType( SvBaseLink& rLink, USHORT nPos, USHORT nType );
    void InsertEntry( const SvBaseLink& rLink, USHORT nPos = LISTBOX_APPEND, sal_Bool bSelect = sal_False);
//#endif
public:
	SvBaseLinksDialog( Window * pParent, SvLinkManager*, BOOL bHtml = FALSE );
	~SvBaseLinksDialog();

	void Execute();

	void SetManager( SvLinkManager* );
	void SetActLink( SvBaseLink * pLink );
};

}

#endif // _LINKDLG_HXX
