/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: debughelper.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:49:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_ucb.hxx"

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/
#include <string.h>
#include <osl/file.hxx>
#include <rtl/ustring.hxx>
#include "debughelper.hxx"


using namespace rtl;
using namespace osl;


void err_msg(const char* p,
             const OUString& aOUString)
{
    OString contentUrl( aOUString.getStr(),
                        aOUString.getLength(),
                        RTL_TEXTENCODING_UTF8 );
    static const char* format1 = "%s%s\n";
    static const char* format2 = "%s\n";
    if(p && strlen(p))
        fprintf(stderr,format1,p,contentUrl.getStr());
    else
        fprintf(stderr,format2,contentUrl.getStr());
}


void msg(const OUString& a)
{
    OString b(a.getStr(),a.getLength(),RTL_TEXTENCODING_UTF8);
    fprintf(stdout,"'%s'\n",b.getStr());
}
    


void wait_for( const char* p )
{
    const char* def = "/export/home/abi/dir";
    char* tmp = const_cast<char*>(def);
    if( p )
        tmp = const_cast<char*>(p);
    
    rtl::OUString aDirectoryName = rtl::OUString::createFromAscii( tmp );
    Directory aDirectory( aDirectoryName );
    while( aDirectory.open() != FileBase::E_None );
    aDirectory.close();
    Directory::remove( aDirectoryName );
}



