#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.10.8.1 $
#
#   last change: $Author: obo $ $Date: 2007/05/08 11:35:33 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..

PRJNAME=sysui
TARGET=cde

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# --- Product Version Information ----------------------------------

.INCLUDE :  ../productversion.mk

# --- Files --------------------------------------------------------

.IF "$(OS)"=="SOLARIS"

# menu launcher files
LAUNCHERFLAGFILES = $(COMMONMISC)$/{$(PRODUCTLIST)}/cdelauncherlist

.IF "$(WITH_LANG)"!=""
ULFDIR = $(COMMONMISC)$/desktopshare
.ELSE			# "$(WITH_LANG)"!=""
ULFDIR:=..$/share
.ENDIF			# "$(WITH_LANG)"!=""

.ENDIF # "$(OS)"=="SOLARIS"

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

.IF "$(OS)"=="SOLARIS"
ALLTAR : $(LAUNCHERFLAGFILES)

$(LAUNCHERFLAGFILES) : brand.pl merge.pl translate.pl makefile.mk $(ULFDIR)/launcher_name.ulf

$(LAUNCHERFLAGFILES): {writer calc draw impress math base printeradmin}.{fp dt}
	@$(MKDIRHIER) $(@:d)types
	-@$(RM) -rf $(@:d)types/*
	@echo Patching CDE frontpanel templates for $(@:d:d:f) ..
	@$(PERL) brand.pl -p "$(PRODUCTNAME.$(@:d:d:f)) $(PRODUCTVERSION.$(@:d:d:f))" -u $(UNIXFILENAME.$(@:d:d:f)) $< $(@:d)
	@echo Translating CDE frontpanel templates for $(@:d:d:f) ..
	@$(PERL) translate.pl -p "$(PRODUCTNAME.$(@:d:d:f)) $(PRODUCTVERSION.$(@:d:d:f))" -d $(@:d)types -k "fp,LABEL,PUSH_ACTION" -k "dt,LABEL,EXEC_STRING" $(ULFDIR)/launcher_name.ulf
	@echo Merging translated CDE frontpanel files for $(@:d:d:f) ..
	@$(PERL) merge.pl -d $(@:d)types -u $(UNIXFILENAME.$(@:d:d:f)) $<
	@echo "$<" > $@

.ENDIF # "$(OS)"=="SOLARIS"
