/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SmartTagMgr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/04 10:44:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    Initial Contributer was Fabalabs Software GmbH, Jakob Lechner
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SMARTTAGMGR_HXX
#define _SMARTTAGMGR_HXX

#include "swtypes.hxx"

#include <vector>
#include <map>
#include <set>

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_SMARTTAGS_XSMARTTAGRECOGNIZER_HPP_
#include "com/sun/star/smarttags/XSmartTagRecognizer.hpp"
#endif

#ifndef _COM_SUN_STAR_SMARTTAGS_XSMARTTAGACTION_HPP_
#include "com/sun/star/smarttags/XSmartTagAction.hpp"
#endif

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif

// SMARTTAGS

using namespace ::rtl;
using namespace com::sun::star::smarttags;
using com::sun::star::frame::XController;

/** Struct: ActionReference
    Constains the refernce to the actions of a specific smarttag. Thus a pointer
    to the smarttag action library and an index of the smarttag within this
    library have to be stored.
*/

struct ActionReference
{
  com::sun::star::uno::Reference<XSmartTagAction> aSmartTagAction;
  sal_Int32 nSmartTagIndex;
  ActionReference(com::sun::star::uno::Reference<XSmartTagAction> _aSmartTagAction, sal_Int32 _nSmartTagIndex);
};

typedef std::pair <const OUString, ActionReference> word_action_Pair;
typedef std::pair <const OUString, ActionReference> recognizer_action_Pair;

/** Class: SmartTagMgr (singleton)
    This class organizes the available smarttag libraries and provides access functions
    to these libraries for the rest of the program.
*/

class SmartTagMgr
{
private:

  std::vector< com::sun::star::uno::Reference<XSmartTagRecognizer> > recognizerList;
  std::multimap <OUString, ActionReference > smarttagMap;
  std::multimap <OUString, ActionReference> recognizedWords;

  static SmartTagMgr* pSmartTagMgr;

  void LoadXmlFiles();
  void LoadLibraries();

  void getMostlXmlFiles( std::vector<OUString>& );

  void associateActionWithRecognizer(com::sun::star::uno::Reference <XSmartTagAction> aActionRef);

  SmartTagMgr();   // Construction via _Create()

public:

  ~SmartTagMgr();

  static SmartTagMgr& getSmartTagMgr();
  static void _Create();
  static void _Delete();

  sal_Bool Recognize(const OUString aWord, com::sun::star::uno::Reference <XController> xController);

  std::vector <ActionReference> getActionRefsByWord(OUString aWord) const;

  bool HasRecognizers() const { return recognizerList.size(); }
};

#endif
